/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import net.jevring.frequencies.v2.filters.AbstractFilter;

public abstract class AbstractLadderFilter
extends AbstractFilter {
    public AbstractLadderFilter(double sampleRate) {
        super(sampleRate, 1000.0, 0.1);
    }

    protected double snapToZero(double n) {
        if (!(n < -1.0E-8) && !(n > 1.0E-8)) {
            return 0.0;
        }
        return n;
    }

    protected double saturate(double input) {
        double x1 = Math.abs(input + 0.95);
        double x2 = Math.abs(input - 0.95);
        return 0.5 * (x1 - x2);
    }

    protected double min(double a, double b) {
        a = b - a;
        a += Math.abs(a);
        a *= 0.5;
        a = b - a;
        return a;
    }

    protected double lerp(double amount, double a, double b) {
        return (1.0 - amount) * a + amount * b;
    }

    protected double fastTanh(double x) {
        double x2 = x * x;
        return x * (27.0 + x2) / (27.0 + 9.0 * x2);
    }

    protected double clip(double value, double saturation, double saturationInverse) {
        double v2 = value * saturationInverse > 1.0 ? 1.0 : (value * saturationInverse < -1.0 ? -1.0 : value * saturationInverse);
        return saturation * (v2 - 0.3333333333333333 * v2 * v2 * v2);
    }
}

