/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.biquad;

import net.jevring.frequencies.v2.filters.moogladders.biquad.AbstractBiQuadFilter;

public abstract class AbstractRBJFilter
extends AbstractBiQuadFilter {
    protected double omega;
    protected double cosOmega;
    protected double sinOmega;
    protected double Q = 1.0;
    protected double alpha;
    protected double A = 1.0;
    protected double[] a = new double[3];
    protected double[] b = new double[3];

    public AbstractRBJFilter(double sampleRate) {
        super(sampleRate);
        this.setCutoffFrequency(1000.0);
    }

    private void updateCoefficients() {
        this.cosOmega = Math.cos(this.omega);
        this.sinOmega = Math.sin(this.omega);
        this.typeDependentUpdateCoefficient();
        double factor = 1.0 / this.a[0];
        double[] aNorm = new double[2];
        double[] bNorm = new double[3];
        aNorm[0] = this.a[1] * factor;
        aNorm[1] = this.a[2] * factor;
        bNorm[0] = this.b[0] * factor;
        bNorm[1] = this.b[1] * factor;
        bNorm[2] = this.b[2] * factor;
        this.setBiquadCoefs(bNorm, aNorm);
    }

    protected abstract void typeDependentUpdateCoefficient();

    @Override
    public void setCutoffFrequency(double c) {
        super.setCutoffFrequency(c);
        this.omega = this.hzToRad(c) / this.sampleRate;
        this.updateCoefficients();
    }

    @Override
    public void setResonance(double q) {
        super.setResonance(q);
        this.Q = q;
        this.updateCoefficients();
    }

    @Override
    public double getMinResonance() {
        return 0.01;
    }

    @Override
    public double getMaxResonance() {
        return 20.0;
    }

    @Override
    public double getResonance() {
        return this.Q;
    }

    protected double hzToRad(double f) {
        return Math.PI * 2 * f;
    }
}

