/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.biquad;

import java.util.Arrays;
import net.jevring.frequencies.v2.filters.AbstractFilter;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;

public abstract class AbstractBiQuadFilter
extends AbstractFilter
implements ModulatedFilter {
    protected double[] bCoef = new double[3];
    protected double[] aCoef = new double[2];
    protected double[] w = new double[2];

    public AbstractBiQuadFilter(double sampleRate) {
        super(sampleRate);
    }

    @Override
    public void reset() {
        Arrays.fill(this.w, 0.0);
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double initialCutoffFrequency = this.cutoffFrequency;
        double initialResonance = this.resonance;
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.setCutoffFrequency(Clamp.clamp(initialCutoffFrequency + frequencyModulation[s] * 20000.0, 20.0, 20000.0));
            this.setResonance(initialResonance + Interpolation.linear(0.0, 1.0, resonanceModulation[s], this.getMinResonance(), this.getMaxResonance()));
            this.loop(samples, s);
        }
        this.setCutoffFrequency(initialCutoffFrequency);
        this.setResonance(initialResonance);
        return samples;
    }

    private void loop(double[] samples, int s) {
        double out = this.bCoef[0] * samples[s] + this.w[0];
        this.w[0] = this.bCoef[1] * samples[s] - this.aCoef[0] * out + this.w[1];
        this.w[1] = this.bCoef[2] * samples[s] - this.aCoef[1] * out;
        samples[s] = out;
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.loop(samples, s);
        }
        return samples;
    }

    double tick(double s) {
        double out = this.bCoef[0] * s + this.w[0];
        this.w[0] = this.bCoef[1] * s - this.aCoef[0] * out + this.w[1];
        this.w[1] = this.bCoef[2] * s - this.aCoef[1] * out;
        return out;
    }

    void setBiquadCoefs(double[] b, double[] a) {
        this.bCoef = b;
        this.aCoef = a;
    }
}

