/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters;

import java.util.Arrays;
import net.jevring.frequencies.v2.filters.CutoffFrequencyFilter;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.QFilter;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;

public class DiodeLadderFilter
implements CutoffFrequencyFilter,
QFilter,
ModulatedFilter {
    private final double sampleRate;
    private volatile double k;
    private volatile double A;
    private final double[] z = new double[5];
    private volatile double ah;
    private volatile double bh;
    private volatile double cutoffFrequency;
    private volatile double fc;
    private volatile double q;

    public DiodeLadderFilter(double sampleRate) {
        this.sampleRate = sampleRate;
        this.setResonance(0.0);
        this.setCutoffFrequency(sampleRate / 2.0);
    }

    @Override
    public void reset() {
        Arrays.fill(this.z, 0.0);
    }

    @Override
    public void setCutoffFrequency(double cutoffFrequency) {
        this.cutoffFrequency = Clamp.clamp(cutoffFrequency, 20.0, 20000.0);
        double nyquistFrequency = this.sampleRate / 2.0;
        this.fc = Clamp.clamp(this.cutoffFrequency / nyquistFrequency, 0.0, 1.0);
        double K = this.fc * Math.PI;
        this.ah = (K - 2.0) / (K + 2.0);
        this.bh = 2.0 / (K + 2.0);
    }

    @Override
    public double getCutoffFrequency() {
        return this.cutoffFrequency;
    }

    @Override
    public void setResonance(double q) {
        this.q = q;
        this.k = 20.0 * q;
        this.A = 1.0 + 0.5 * this.k;
    }

    @Override
    public double getMaxResonance() {
        return 1.0;
    }

    @Override
    public double getResonance() {
        return this.q;
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double initialCutoffFrequency = this.cutoffFrequency;
        double initialResonance = this.q;
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            this.setCutoffFrequency(initialCutoffFrequency + frequencyModulation[i] * 20000.0);
            this.setResonance(initialResonance + Interpolation.linear(0.0, 1.0, resonanceModulation[i], this.getMinResonance(), this.getMaxResonance()));
            this.loop(input[i], output, i);
        }
        this.setCutoffFrequency(initialCutoffFrequency);
        this.setResonance(initialResonance);
        return output;
    }

    @Override
    public double[] apply(double[] input) {
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            this.loop(input[i], output, i);
        }
        return output;
    }

    private void loop(double x1, double[] output, int i) {
        double x = x1;
        double a = Math.PI * this.fc;
        a = 2.0 * Math.tan(0.5 * a);
        double ainv = 1.0 / a;
        double a2 = a * a;
        double b = 2.0 * a + 1.0;
        double b2 = b * b;
        double c = 1.0 / (2.0 * a2 * a2 - 4.0 * a2 * b2 + b2 * b2);
        double g0 = 2.0 * a2 * a2 * c;
        double g = g0 * this.bh;
        double s0 = (a2 * a * this.z[0] + a2 * b * this.z[1] + this.z[2] * (b2 - 2.0 * a2) * a + this.z[3] * (b2 - 3.0 * a2) * b) * c;
        double s = this.bh * s0 - this.z[4];
        double y5 = (g * x + s) / (1.0 + g * this.k);
        double y0 = DiodeLadderFilter.clip(x - this.k * y5);
        y5 = g * y0 + s;
        double y4 = g0 * y0 + s0;
        double y3 = (b * y4 - this.z[3]) * ainv;
        double y2 = (b * y3 - a * y4 - this.z[2]) * ainv;
        double y1 = (b * y2 - a * y3 - this.z[1]) * ainv;
        this.z[0] = this.z[0] + 4.0 * a * (y0 - y1 + y2);
        this.z[1] = this.z[1] + 2.0 * a * (y1 - 2.0 * y2 + y3);
        this.z[2] = this.z[2] + 2.0 * a * (y2 - 2.0 * y3 + y4);
        this.z[3] = this.z[3] + 2.0 * a * (y3 - 2.0 * y4);
        this.z[4] = this.bh * y4 + this.ah * y5;
        output[i] = this.A * y4;
    }

    private static double clip(double d) {
        return d / (1.0 + Math.abs(d));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

