/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters;

import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.filters.CutoffFrequencyFilter;
import net.jevring.frequencies.v2.filters.Filter;
import net.jevring.frequencies.v2.filters.Filters;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.NoopFilter;
import net.jevring.frequencies.v2.filters.QFilter;
import net.jevring.frequencies.v2.filters.alpha.AlphaFilter;
import net.jevring.frequencies.v2.math.Interpolation;

public class ControlledFilter
implements ModulatedFilter {
    private volatile Filter filter = new NoopFilter();

    public ControlledFilter(String filterControlPrefix, Controls controls, Filters filters) {
        final Control resonanceControl = controls.getControl(this.controlName(filterControlPrefix, "q-resonance-emphasis"));
        resonanceControl.addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                Filter filter = ControlledFilter.this.filter;
                if (filter instanceof QFilter) {
                    QFilter qFilter = (QFilter)filter;
                    qFilter.setResonance(Interpolation.linear(min, max, newValue, qFilter.getMinResonance(), qFilter.getMaxResonance()));
                }
            }
        });
        final Control filterCutoffFrequencyControl = controls.getControl(this.controlName(filterControlPrefix, "filter-cutoff-frequency"));
        filterCutoffFrequencyControl.addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                Filter filter = ControlledFilter.this.filter;
                if (filter instanceof CutoffFrequencyFilter) {
                    CutoffFrequencyFilter cutoffFrequencyFilter = (CutoffFrequencyFilter)filter;
                    cutoffFrequencyFilter.setCutoffFrequency(newValue);
                } else {
                    filter = ControlledFilter.this.filter;
                    if (filter instanceof AlphaFilter) {
                        AlphaFilter alphaFilter = (AlphaFilter)filter;
                        double alpha = Interpolation.linear(min, max, newValue, 0.0, 0.5);
                        alphaFilter.setAlpha(alpha);
                    }
                }
            }
        });
        controls.getDiscreteControl(this.controlName(filterControlPrefix, "filter")).mapping(filters::create).addListener(new DiscreteControlListener<Filter>(){

            @Override
            public void valueChanged(Filter selectedFilter, Object source) {
                ControlledFilter.this.filter = selectedFilter;
                filterCutoffFrequencyControl.updateListeners(this);
                resonanceControl.updateListeners(this);
            }
        });
    }

    private String controlName(String filterControlPrefix, String controlSuffix) {
        if (filterControlPrefix == null) {
            return controlSuffix;
        }
        return filterControlPrefix + "-" + controlSuffix;
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        Filter filter = this.filter;
        if (filter instanceof ModulatedFilter) {
            ModulatedFilter modulatedFilter = (ModulatedFilter)filter;
            return modulatedFilter.apply(input, frequencyModulation, resonanceModulation);
        }
        return this.apply(input);
    }

    @Override
    public double[] apply(double[] input) {
        return this.filter.apply(input);
    }

    @Override
    public void reset() {
        this.filter.reset();
    }
}

