/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.envelopes;

import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.envelopes.AttackEnvelope;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.Envelopes;
import net.jevring.frequencies.v2.envelopes.LinearADSREnvelope;
import net.jevring.frequencies.v2.envelopes.LoopingEnvelope;
import net.jevring.frequencies.v2.envelopes.Phase;
import net.jevring.frequencies.v2.envelopes.ReleaseEnvelope;
import net.jevring.frequencies.v2.envelopes.SustainEnvelope;

public class ControlledEnvelope
implements Envelope {
    private volatile Envelope envelope = new LinearADSREnvelope();

    public ControlledEnvelope(Controls controls, Envelopes envelopes, String controlPrefix) {
        controls.getDiscreteControl(controlPrefix + "-envelope-type").mapping(envelopes::create).addListener(new DiscreteControlListener<Envelope>(){

            @Override
            public void valueChanged(Envelope newEnvelope, Object source) {
                ControlledEnvelope.this.copyEnvelopeSettings(ControlledEnvelope.this.envelope, newEnvelope);
                ControlledEnvelope.this.envelope = newEnvelope;
            }
        });
        controls.getControl(controlPrefix + "-envelope-attack").addListener((min, newValue, max, source) -> this.setAttackIfPossible((long)newValue));
        controls.getControl(controlPrefix + "-envelope-decay").addListener((min, newValue, max, source) -> this.setDecayIfPossible((long)newValue));
        controls.getControl(controlPrefix + "-envelope-sustain").addListener((min, newValue, max, source) -> this.setSustainIfPossible(newValue));
        controls.getControl(controlPrefix + "-envelope-release").addListener((min, newValue, max, source) -> this.setReleaseIfPossible((long)newValue));
        controls.getBooleanControl(controlPrefix + "-envelope-loop").addListener((loop, source) -> this.setLoopIfPossible((boolean)loop));
    }

    @Override
    public double[] levels(long nanosecondsActivated, long nanosecondsDeactivated, int samplesToGenerate, double sampleRate) {
        return this.envelope.levels(nanosecondsActivated, nanosecondsDeactivated, samplesToGenerate, sampleRate);
    }

    @Override
    public Phase phase(long nanosecondsActivated, long nanosecondsDeactivated) {
        return this.envelope.phase(nanosecondsActivated, nanosecondsDeactivated);
    }

    @Override
    public void reset() {
        this.envelope.reset();
    }

    private void setLoopIfPossible(boolean loop) {
        Envelope envelope = this.envelope;
        if (envelope instanceof LoopingEnvelope) {
            LoopingEnvelope loopingEnvelope = (LoopingEnvelope)envelope;
            loopingEnvelope.setLoop(loop);
        }
    }

    private void setReleaseIfPossible(long releaseInMilliseconds) {
        Envelope envelope = this.envelope;
        if (envelope instanceof ReleaseEnvelope) {
            ReleaseEnvelope releaseEnvelope = (ReleaseEnvelope)envelope;
            releaseEnvelope.setReleaseInMillis(releaseInMilliseconds);
        }
    }

    private void setSustainIfPossible(double sustain) {
        Envelope envelope = this.envelope;
        if (envelope instanceof SustainEnvelope) {
            SustainEnvelope sustainEnvelope = (SustainEnvelope)envelope;
            sustainEnvelope.setSustainLevel(sustain);
        }
    }

    private void setDecayIfPossible(long decayTimeInMillis) {
        Envelope envelope = this.envelope;
        if (envelope instanceof DecayEnvelope) {
            DecayEnvelope decayEnvelope = (DecayEnvelope)envelope;
            decayEnvelope.setDecayInMillis(decayTimeInMillis);
        }
    }

    private void setAttackIfPossible(long attackTimeInMilliseconds) {
        Envelope envelope = this.envelope;
        if (envelope instanceof AttackEnvelope) {
            AttackEnvelope attackEnvelope = (AttackEnvelope)envelope;
            attackEnvelope.setAttackInMillis(attackTimeInMilliseconds);
        }
    }

    private void copyEnvelopeSettings(Envelope existingEnvelope, Envelope newEnvelope) {
        Envelope envelope = existingEnvelope;
        if (envelope instanceof LoopingEnvelope) {
            LoopingEnvelope existingLoopEnvelope = (LoopingEnvelope)envelope;
            envelope = newEnvelope;
            if (envelope instanceof LoopingEnvelope) {
                LoopingEnvelope newLoopEnvelope = (LoopingEnvelope)envelope;
                newLoopEnvelope.setLoop(existingLoopEnvelope.isLoop());
            }
        }
        if ((envelope = existingEnvelope) instanceof AttackEnvelope) {
            AttackEnvelope existingAttackEnvelope = (AttackEnvelope)envelope;
            envelope = newEnvelope;
            if (envelope instanceof AttackEnvelope) {
                AttackEnvelope newAttackEnvelope = (AttackEnvelope)envelope;
                newAttackEnvelope.setAttackInMillis(existingAttackEnvelope.getAttackInMillis());
            }
        }
        if ((envelope = existingEnvelope) instanceof DecayEnvelope) {
            DecayEnvelope existingDecayEnvelope = (DecayEnvelope)envelope;
            envelope = newEnvelope;
            if (envelope instanceof DecayEnvelope) {
                DecayEnvelope newDecayEnvelope = (DecayEnvelope)envelope;
                newDecayEnvelope.setDecayInMillis(existingDecayEnvelope.getDecayInMillis());
            }
        }
        if ((envelope = existingEnvelope) instanceof SustainEnvelope) {
            SustainEnvelope existingSustainEnvelope = (SustainEnvelope)envelope;
            envelope = newEnvelope;
            if (envelope instanceof SustainEnvelope) {
                SustainEnvelope newSustainEnvelope = (SustainEnvelope)envelope;
                newSustainEnvelope.setSustainLevel(existingSustainEnvelope.getSustainLevel());
            }
        }
        if ((envelope = existingEnvelope) instanceof ReleaseEnvelope) {
            ReleaseEnvelope existingReleaseEnvelope = (ReleaseEnvelope)envelope;
            envelope = newEnvelope;
            if (envelope instanceof ReleaseEnvelope) {
                ReleaseEnvelope newReleaseEnvelope = (ReleaseEnvelope)envelope;
                newReleaseEnvelope.setReleaseInMillis(existingReleaseEnvelope.getReleaseInMillis());
            }
        }
    }
}

