/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.engine;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.math.Clamp;

public class MasterVolume {
    private final BooleanControl clipControl;
    private final Control overdriveControl;

    public MasterVolume(Controls controls) {
        this.overdriveControl = controls.getControl("overdrive-volume");
        this.clipControl = controls.getBooleanControl("clip");
    }

    double[] apply(double[] samples) {
        boolean clip = this.clipControl.get();
        double overdrive = this.overdriveControl.getCurrentValue();
        double[] output = new double[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            double masterSample = samples[i] * overdrive;
            output[i] = clip ? Clamp.clamp(masterSample, -1.0, 1.0) : masterSample;
        }
        return output;
    }
}

