/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.engine;

import java.util.List;
import java.util.Objects;
import javax.sound.sampled.SourceDataLine;
import net.jevring.frequencies.v2.effects.EffectsChain;
import net.jevring.frequencies.v2.engine.MasterVolume;
import net.jevring.frequencies.v2.engine.SamplesToBytesConverter;
import net.jevring.frequencies.v2.engine.Voice;
import net.jevring.frequencies.v2.hooks.Visualizer;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.input.InstructionInput;
import net.jevring.frequencies.v2.util.SignalEnergyAdder;

public class MainLoopPullingEngine {
    private static final double ONE_HUNDREDTH_OF_A_SECOND_IN_NANOS = 1.0E7;
    private static final double NANOS_PER_SECOND = 1.0E9;
    private final SamplesToBytesConverter samplesToBytesConverter;
    private final InstructionInput instructionInput;
    private final EffectsChain effectsChain;
    private final MasterVolume masterVolume;
    private final float sampleRate;
    private final Voice[] voices;
    private volatile boolean running = false;
    private SourceDataLine sourceDataLine;
    private Visualizer visualizer;
    private Thread thread;

    public MainLoopPullingEngine(SamplesToBytesConverter samplesToBytesConverter, InstructionInput instructionInput, EffectsChain effectsChain, MasterVolume masterVolume, float sampleRate, Voice[] voices) {
        this.samplesToBytesConverter = samplesToBytesConverter;
        this.instructionInput = instructionInput;
        this.effectsChain = effectsChain;
        this.masterVolume = masterVolume;
        this.sampleRate = sampleRate;
        this.voices = voices;
    }

    private void loop() {
        long previousNanos = System.nanoTime();
        while (this.running) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                long nowNanos = System.nanoTime();
                long elapsedNanos = nowNanos - previousNanos;
                if (!((double)elapsedNanos > 1.0E7)) continue;
                previousNanos = nowNanos;
                int samplesToGenerate = this.samplesToGenerate(elapsedNanos);
                List<Instruction> instructions = this.instructionInput.inputInstructions();
                double[] samples = this.pullSamplesFromVoices(samplesToGenerate, instructions);
                samples = this.effectsChain.apply(samples);
                samples = this.masterVolume.apply(samples);
                byte[] soundOutputBytes = this.samplesToBytesConverter.convert(samples);
                this.sourceDataLine.write(soundOutputBytes, 0, soundOutputBytes.length);
                this.visualizer.visualizeWaveformChunk(samples);
                this.visualizer.visualizeModulation(samples.length, instructions);
                double loopTimeInNanoseconds = System.nanoTime() - nowNanos;
                double percentageOfMax = loopTimeInNanoseconds / 1.0E7 * 100.0;
                this.visualizer.visualizeLoopTime(percentageOfMax);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private double[] pullSamplesFromVoices(int samplesToGenerate, List<Instruction> instructions) {
        SignalEnergyAdder output = new SignalEnergyAdder(this.voices.length, samplesToGenerate);
        for (int i = 0; i < this.voices.length; ++i) {
            Voice voice = this.voices[i];
            voice.next();
            Instruction instruction = instructions.get(i);
            if (instruction == null) continue;
            double[] samplesForVoice = voice.samples(instruction, samplesToGenerate);
            output.add(samplesForVoice);
        }
        return output.getOutput();
    }

    private int samplesToGenerate(double elapsedNanos) {
        double proportionOfASecond = elapsedNanos / 1.0E9;
        return (int)Math.round(proportionOfASecond * (double)this.sampleRate);
    }

    public synchronized void start(SourceDataLine sourceDataLine, Visualizer visualizer) {
        if (this.thread != null) {
            throw new IllegalStateException("Already running");
        }
        this.sourceDataLine = Objects.requireNonNull(sourceDataLine);
        this.visualizer = Objects.requireNonNull(visualizer);
        this.running = true;
        this.thread = new Thread(this::loop, "main-loop-pulling-engine");
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread == null) {
            throw new IllegalStateException("Not running");
        }
        this.running = false;
        this.sourceDataLine.flush();
        this.sourceDataLine.close();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.thread = null;
    }
}

