/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects.delay;

import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.effects.CircularBuffer;
import net.jevring.frequencies.v2.effects.DryWetMixer;
import net.jevring.frequencies.v2.effects.Effect;

public class DelayAndEcho
implements Effect {
    private final Control dryWetMix;
    private final Control delayInMilliseconds;
    private final Control decay;
    private final CircularBuffer buffer;
    private final double samplesPerMillisecond;

    public DelayAndEcho(float sampleRate, Control dryWetMix, Control delayInMilliseconds, Control decay) {
        this.decay = decay;
        this.dryWetMix = dryWetMix;
        this.delayInMilliseconds = delayInMilliseconds;
        this.samplesPerMillisecond = (double)sampleRate / 1000.0;
        this.buffer = new CircularBuffer(sampleRate, 3.0);
    }

    private int delayInSamples() {
        return (int)(this.samplesPerMillisecond * (double)Math.round(this.delayInMilliseconds.getCurrentValue()));
    }

    @Override
    public double[] apply(double[] input) {
        int delayInSamples = this.delayInSamples();
        this.buffer.add(input);
        double decay = 1.0 - this.decay.getCurrentValue();
        double[] wet = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            double delayValue = this.buffer.get(i - delayInSamples);
            this.buffer.increase(i, delayValue * decay);
            wet[i] = delayValue;
        }
        return DryWetMixer.mix(input, wet, this.dryWetMix.getCurrentValue());
    }

    public void reset() {
        this.buffer.reset();
    }
}

