/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects.bitcrusher;

import java.util.Arrays;
import java.util.Locale;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.curves.Linear;
import net.jevring.frequencies.v2.effects.Effect;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.oscillators.Oscillator;
import net.jevring.frequencies.v2.waveforms.SawtoothWaveform;

public class BitCrusher
implements Effect {
    private final double[] buffer = new double[1024];
    private final Control downsampling;
    private final Control resolution;
    private int endOfBufferPointer = 0;
    private double leftoverBucket;
    private int leftoverSamplesRemainingInChunk;

    public BitCrusher(Control downsampling, Control resolution) {
        this.downsampling = downsampling;
        this.resolution = resolution;
    }

    private void copyIntoBuffer(double[] input) {
        int p = this.endOfBufferPointer;
        for (int i = 0; i < input.length; ++i) {
            this.buffer[p++ % this.buffer.length] = input[i];
        }
        this.endOfBufferPointer = p % this.buffer.length;
    }

    @Override
    public double[] apply(double[] input) {
        int samplesPerChunk = (int)this.downsampling.getCurrentValue();
        int resolutionInBits = (int)this.resolution.getCurrentValue();
        if (samplesPerChunk == 1 && resolutionInBits == 16) {
            return input;
        }
        double[] output = new double[input.length];
        int bufferStartPointer = this.endOfBufferPointer;
        this.copyIntoBuffer(input);
        int samplesRemainingInChunk = samplesPerChunk;
        if (this.leftoverSamplesRemainingInChunk != 0) {
            samplesRemainingInChunk = this.leftoverSamplesRemainingInChunk;
        }
        double bucket = 0.0;
        if (this.leftoverBucket != 0.0) {
            bucket = this.leftoverBucket;
        }
        int outputPointer = 0;
        for (int i = 0; i < input.length; ++i) {
            int bufferPointer = bufferStartPointer + i;
            if (bufferPointer < 0) {
                bufferPointer += this.buffer.length;
            }
            double sample = this.buffer[bufferPointer % this.buffer.length];
            bucket += sample;
            if (--samplesRemainingInChunk != 0) continue;
            double chunkAverage = Clamp.clamp(bucket / (double)samplesPerChunk, -1.0, 1.0);
            double atReducedResolution = BitCrusher.reduceResolutionMultiplyDivide(chunkAverage, resolutionInBits);
            int toIndex = Math.min(outputPointer + samplesPerChunk, output.length);
            Arrays.fill(output, outputPointer, toIndex, atReducedResolution);
            bucket = 0.0;
            samplesRemainingInChunk = samplesPerChunk;
            outputPointer = toIndex;
        }
        if (samplesRemainingInChunk != samplesPerChunk) {
            double chunkAverage = Clamp.clamp(bucket / (double)(samplesPerChunk - samplesRemainingInChunk), -1.0, 1.0);
            double atReducedResolution = BitCrusher.reduceResolutionMultiplyDivide(chunkAverage, resolutionInBits);
            Arrays.fill(output, outputPointer, output.length, atReducedResolution);
        }
        this.leftoverBucket = bucket;
        this.leftoverSamplesRemainingInChunk = samplesRemainingInChunk;
        return output;
    }

    private static double reduceResolutionMultiplyDivide(double v, int resolutionInBits) {
        double scaling = Math.pow(2.0, resolutionInBits);
        int scaledUp = (int)(v * scaling);
        double scaledBackDown = (double)scaledUp / scaling;
        return scaledBackDown;
    }

    private static double reduceResolution(double v, int resolutionInBits) {
        int shiftAmount = 16 - resolutionInBits;
        short asShort = (short)(v * 32767.0);
        asShort = (short)(asShort >> shiftAmount);
        asShort = (short)(asShort << shiftAmount);
        return (double)asShort / 32767.0;
    }

    public static void main(String[] args) {
        Control downsampling = new Control("", 1.0, 1.0, 128.0, new Linear(), true);
        Control resolution = new Control("", 1.0, 4.0, 16.0, new Linear(), true);
        BitCrusher bitCrusher = new BitCrusher(downsampling, resolution);
        int chunkSize = 44;
        double sampleRate = 44100.0;
        Oscillator oscillator = new Oscillator(sampleRate);
        oscillator.setWaveform(new SawtoothWaveform(true));
        double[] zeroes = new double[4096];
        for (int i = 0; i <= 1000; i += chunkSize) {
            double[] values;
            for (double d : values = bitCrusher.apply(oscillator.generateSamples(chunkSize, 440.0, zeroes, zeroes, zeroes, zeroes, zeroes, zeroes, zeroes, zeroes))) {
                System.out.printf(Locale.US, "%f%n", d);
            }
        }
    }
}

