/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects;

import java.util.Arrays;

public class CircularBuffer {
    private final double[] buffer;
    private int endOfBufferPointer = 0;
    private int startOfBufferPointer = 0;

    public CircularBuffer(double sampleRate, double bufferLengthInSeconds) {
        this((int)Math.round(sampleRate * bufferLengthInSeconds));
    }

    public CircularBuffer(int lengthInSamples) {
        this.buffer = new double[lengthInSamples];
    }

    private void copyIntoBuffer(double[] input) {
        int remainingInBuffer = this.buffer.length - this.endOfBufferPointer;
        if (input.length < remainingInBuffer) {
            System.arraycopy(input, 0, this.buffer, this.endOfBufferPointer, input.length);
            this.endOfBufferPointer += input.length;
        } else {
            System.arraycopy(input, 0, this.buffer, this.endOfBufferPointer, remainingInBuffer);
            System.arraycopy(input, remainingInBuffer, this.buffer, 0, input.length - remainingInBuffer);
            this.endOfBufferPointer = input.length - remainingInBuffer;
        }
    }

    public void add(double[] input) {
        this.startOfBufferPointer = this.endOfBufferPointer;
        this.copyIntoBuffer(input);
    }

    public double get(int relativeBufferPointer) {
        return this.buffer[this.getBufferPointer(relativeBufferPointer)];
    }

    public void set(int relativeBufferPointer, double value) {
        this.buffer[this.getBufferPointer((int)relativeBufferPointer)] = value;
    }

    public void increase(int relativeBufferPointer, double by) {
        int n = this.getBufferPointer(relativeBufferPointer);
        this.buffer[n] = this.buffer[n] + by;
    }

    private int getBufferPointer(int relativeBufferPointer) {
        int bufferPointer = this.startOfBufferPointer + relativeBufferPointer;
        if (bufferPointer < 0) {
            bufferPointer += this.buffer.length;
        }
        return bufferPointer % this.buffer.length;
    }

    public void reset() {
        Arrays.fill(this.buffer, 0.0);
    }

    public double[] getLast(int length) {
        if (this.endOfBufferPointer > length) {
            return Arrays.copyOfRange(this.buffer, this.endOfBufferPointer - length, this.endOfBufferPointer);
        }
        double[] output = new double[length];
        int fromStart = length - this.endOfBufferPointer;
        int fromEnd = length - fromStart;
        System.arraycopy(this.buffer, this.buffer.length - fromStart, output, 0, fromStart);
        System.arraycopy(this.buffer, 0, output, fromStart, fromEnd);
        return output;
    }

    public static void main(String[] args) {
        CircularBuffer b = new CircularBuffer(10.0, 1.0);
        b.add(new double[]{1.0, 2.0, 3.0, 4.0});
        b.add(new double[]{5.0, 6.0, 7.0, 8.0, 9.0, 10.0});
        b.add(new double[]{11.0, 12.0, 13.0, 14.0, 15.0});
        System.out.println("last 8 = " + Arrays.toString(b.getLast(8)));
        System.out.println("last 10 = " + Arrays.toString(b.getLast(10)));
        System.out.println("last 3 = " + Arrays.toString(b.getLast(3)));
    }
}

