/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.control;

import java.util.function.Function;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.control.DiscreteControlListener;

public class MappingDiscreteControl<T> {
    private final DiscreteControl discreteControl;
    private final Function<String, T> mapper;

    MappingDiscreteControl(DiscreteControl discreteControl, Function<String, T> mapper) {
        this.discreteControl = discreteControl;
        this.mapper = mapper;
    }

    public T get() {
        return this.mapper.apply(this.discreteControl.get());
    }

    public void addListener(final DiscreteControlListener<T> listener) {
        this.discreteControl.addListener(new DiscreteControlListener<String>(){

            @Override
            public void valueChanged(String value, Object source) {
                listener.valueChanged(MappingDiscreteControl.this.mapper.apply(value), source);
            }
        });
    }
}

