/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.control;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.control.MappingDiscreteControl;

public class DiscreteControl {
    private final List<DiscreteControlListener<String>> listeners = new ArrayList<DiscreteControlListener<String>>();
    private final List<String> allowedValues;
    private final String defaultValue;
    private volatile String value;
    private final String key;

    DiscreteControl(String key, List<String> allowedValues, String defaultValue) {
        this.allowedValues = List.copyOf(allowedValues);
        if (!allowedValues.contains(defaultValue)) {
            throw new IllegalArgumentException(String.format("Can't specify a default value (%s) that doesn't exist in the list of allowed values %s for control %s", defaultValue, allowedValues, key));
        }
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.key = key;
    }

    public void set(String myValue, Object source) {
        this.value = myValue;
        if (!this.allowedValues.contains(myValue)) {
            throw new IllegalArgumentException(String.format("Disallowed value %s for %s, allowed values: %s", myValue, this.key, this.allowedValues));
        }
        this.updateListeners(source);
    }

    private void updateListeners(Object source) {
        for (DiscreteControlListener<String> listener : this.listeners) {
            listener.valueChanged(this.value, source);
        }
    }

    public void reset(Object source) {
        this.value = this.defaultValue;
        this.updateListeners(source);
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public String getKey() {
        return this.key;
    }

    public String get() {
        return this.value;
    }

    public <T> MappingDiscreteControl<T> mapping(Function<String, T> mapper) {
        return new MappingDiscreteControl<T>(this, mapper);
    }

    public void addListener(DiscreteControlListener<String> listener) {
        this.listeners.add(listener);
        listener.valueChanged(this.value, this);
    }

    public void deleteListener(DiscreteControlListener<String> listener) {
        this.listeners.remove(listener);
    }
}

