/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.control;

import java.util.ArrayList;
import java.util.List;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.RawDoubleControlListener;
import net.jevring.frequencies.v2.control.RawLongControlListener;
import net.jevring.frequencies.v2.control.curves.Curve;
import net.jevring.frequencies.v2.math.Clamp;

public class Control {
    private final List<ControlListener> listeners = new ArrayList<ControlListener>();
    private final List<RawDoubleControlListener> rawDoubleListeners = new ArrayList<RawDoubleControlListener>();
    private final List<RawLongControlListener> rawLongListeners = new ArrayList<RawLongControlListener>();
    private final double defaultValue;
    private final boolean round;
    private final String key;
    private volatile double min;
    private volatile double value;
    private volatile double max;
    private volatile Curve curve;

    public Control(String key, double min, double value, double max, Curve curve, boolean round) {
        this.key = key;
        this.curve = curve;
        this.round = round;
        if (round) {
            this.defaultValue = Math.round(value);
            this.min = Math.round(min);
            this.value = Math.round(value);
            this.max = Math.round(max);
        } else {
            this.defaultValue = value;
            this.min = min;
            this.value = value;
            this.max = max;
        }
    }

    public void reset(Object source) {
        this.value = this.defaultValue;
        this.updateListeners(source);
    }

    public String getKey() {
        return this.key;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public boolean isStepped() {
        return this.round;
    }

    public void set(double myMin, double myValue, double myMax, Object source) {
        double scaledValue = this.curve.scale(myMin, myMax, myValue, this.min, this.max);
        this.value = this.round ? (double)Math.round(scaledValue) : scaledValue;
        this.updateListeners(source);
    }

    public void updateListeners(Object source) {
        for (ControlListener controlListener : this.listeners) {
            controlListener.valueChanged(this.min, this.value, this.max, source);
        }
        for (RawDoubleControlListener rawDoubleControlListener : this.rawDoubleListeners) {
            rawDoubleControlListener.rawValueChanged(this.value);
        }
        for (RawLongControlListener rawLongControlListener : this.rawLongListeners) {
            rawLongControlListener.rawValueChanged((long)this.value);
        }
    }

    public void setRaw(double value) {
        this.value = Clamp.clamp(value, this.min, this.max);
        this.updateListeners(this);
    }

    public double getCurrentValue() {
        if (this.round) {
            return Math.round(this.value);
        }
        return this.value;
    }

    public void addListener(ControlListener listener) {
        this.listeners.add(listener);
        listener.valueChanged(this.min, this.value, this.max, this);
    }

    public void addRawDoubleListener(RawDoubleControlListener rawListener) {
        this.rawDoubleListeners.add(rawListener);
        rawListener.rawValueChanged(this.value);
    }

    public void addRawLongListener(RawLongControlListener rawListener) {
        this.rawLongListeners.add(rawListener);
        rawListener.rawValueChanged((long)this.value);
    }

    public String toString() {
        return "Control{listeners=" + this.listeners + ", min=" + this.min + ", value=" + this.value + ", max=" + this.max + ", curve=" + this.curve + "}";
    }
}

