/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.configuration;

import java.util.List;
import java.util.Random;
import net.jevring.frequencies.v2.configuration.Randomizer;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrix;
import net.jevring.frequencies.v2.modulation.matrix.ModulationSource;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;

public class NiceRandomizer
implements Randomizer {
    @Override
    public void randomizeSequencer(Controls controls) {
        Random random = new Random();
        controls.getControl("sequencer-steps").setRaw(16.0);
        for (Control control : controls.getControls().values()) {
            if (control.getKey().startsWith("sequencer-note-")) {
                control.set(0.0, 36 + random.nextInt(8), 127.0, this);
                continue;
            }
            if (!control.getKey().startsWith("sequencer-gate-")) continue;
            control.set(0.0, 0.6, 0.9, this);
        }
    }

    @Override
    public void randomizeSynthesizer(Controls controls, ModulationMatrix modulationMatrix) {
        Random random = new Random();
        DiscreteControl filter = controls.getDiscreteControl("filter");
        int randomFilter = random.nextInt(3);
        if (randomFilter < 1) {
            filter.set("LowPassJuceIIRFilter", this);
            controls.getControl("filter-cutoff-frequency").set(0.0, random.nextDouble(), 1.0, this);
        } else if (randomFilter < 2) {
            filter.set("HighPassJuceIIRFilter", this);
            controls.getControl("filter-cutoff-frequency").set(0.0, random.nextDouble() * 0.5, 1.0, this);
        } else {
            filter.set("BandPassRBJFilter", this);
            controls.getControl("filter-cutoff-frequency").set(0.0, random.nextDouble() * 0.5, 1.0, this);
        }
        controls.getControl("q-resonance-emphasis").set(0.0, 0.1 + random.nextDouble(), 1.0, this);
        controls.getControl("primary-oscillator-octave-offset").set(-4.0, this.random(-2, -1, 0, 1, 2), 4.0, this);
        controls.getControl("secondary-oscillator-octave-offset").set(-4.0, this.random(-2, -1, 0, 1, 2), 4.0, this);
        controls.getControl("primary-oscillator-detune-semi-tones").set(-12.0, this.random(-7, -5, -3, 0, 3, 5, 7), 12.0, this);
        controls.getControl("secondary-oscillator-detune-semi-tones").set(-12.0, this.random(-7, -5, -3, 0, 3, 5, 7), 12.0, this);
        controls.getControl("primary-oscillator-variable-waveform").set(0.0, random.nextDouble(), 1.0, this);
        controls.getControl("secondary-oscillator-variable-waveform").set(0.0, random.nextDouble(), 1.0, this);
        controls.getControl("primary-oscillator-quantization-steps").set(0.0, random.nextDouble(), 1.0, this);
        controls.getControl("secondary-oscillator-quantization-steps").set(0.0, random.nextDouble(), 1.0, this);
        controls.getControl("primary-oscillator-unison-voices").setRaw(this.random(1, 3, 5, 7));
        controls.getControl("primary-oscillator-unison-detune-semi-tones").setRaw(this.random(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0));
        controls.getControl("secondary-oscillator-unison-voices").setRaw(this.random(1, 3, 5, 7));
        controls.getControl("secondary-oscillator-unison-detune-semi-tones").setRaw(this.random(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0));
        controls.getControl("primary-oscillator-wave-shape").setRaw(random.nextDouble() * -1.0);
        controls.getControl("secondary-oscillator-wave-shape").setRaw(random.nextDouble() * -1.0);
        controls.getControl("noise-oscillator-volume").set(0.0, random.nextDouble(), 2.0, this);
        double envelopeTimeRange = 0.4;
        controls.getControl("volume-envelope-attack").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        controls.getControl("volume-envelope-decay").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        controls.getControl("volume-envelope-sustain").set(0.0, 0.6, 1.0, this);
        controls.getControl("volume-envelope-release").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        this.randomize(controls.getDiscreteControl("volume-envelope-type"));
        controls.getControl("filter-envelope-attack").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        controls.getControl("filter-envelope-decay").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        controls.getControl("filter-envelope-sustain").set(0.0, 0.6, 1.0, this);
        controls.getControl("filter-envelope-release").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        this.randomize(controls.getDiscreteControl("filter-envelope-type"));
        controls.getControl("modulation-envelope-attack").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        controls.getControl("modulation-envelope-decay").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        controls.getControl("modulation-envelope-sustain").set(0.0, 0.6, 1.0, this);
        controls.getControl("modulation-envelope-release").set(0.0, random.nextDouble() * envelopeTimeRange, 1.0, this);
        this.randomize(controls.getDiscreteControl("modulation-envelope-type"));
        int modulationMatrixSlots = (int)(Math.random() * 10.0);
        List<ModulationSource> modulationSources = List.of(ModulationSource.LFO1, ModulationSource.LFO2, ModulationSource.LFO3, ModulationSource.SAMPLE_AND_HOLD, ModulationSource.AMPLIFIER_ENVELOPE, ModulationSource.FILTER_ENVELOPE, ModulationSource.MODULATION_ENVELOPE);
        List<ModulationTarget> modulationTargets = List.of(ModulationTarget.PRIMARY_OSCILLATOR_OCTAVE, ModulationTarget.PRIMARY_OSCILLATOR_DETUNE, ModulationTarget.PRIMARY_OSCILLATOR_WAVE_SHAPE, ModulationTarget.PRIMARY_OSCILLATOR_WAVEFORM_VARIATION, ModulationTarget.PRIMARY_OSCILLATOR_QUANTIZATION_STEPS, ModulationTarget.SECONDARY_OSCILLATOR_OCTAVE, ModulationTarget.SECONDARY_OSCILLATOR_DETUNE, ModulationTarget.SECONDARY_OSCILLATOR_WAVE_SHAPE, ModulationTarget.SECONDARY_OSCILLATOR_WAVEFORM_VARIATION, ModulationTarget.SECONDARY_OSCILLATOR_QUANTIZATION_STEPS, ModulationTarget.FILTER_CUTOFF_FREQUENCY, ModulationTarget.FILTER_RESONANCE);
        for (int i = 0; i < modulationMatrixSlots; ++i) {
            ModulationSource modulationSource = modulationSources.get((int)(Math.random() * (double)(modulationSources.size() - 1)));
            if (modulationSource == ModulationSource.SAMPLE_AND_HOLD) {
                controls.getControl("sample-and-hold-frequency").set(0.0, random.nextDouble(), 1.0, this);
                controls.getControl("sample-and-hold-slew").set(0.0, random.nextDouble(), 1.0, this);
            } else if (modulationSource == ModulationSource.LFO1) {
                controls.getControl("lfo1-variable-waveform").set(0.0, random.nextDouble(), 1.0, this);
                controls.getControl("lfo1-frequency").set(0.0, random.nextDouble(), 1.0, this);
            } else if (modulationSource == ModulationSource.LFO2) {
                controls.getControl("lfo2-variable-waveform").set(0.0, random.nextDouble(), 1.0, this);
                controls.getControl("lfo2-frequency").set(0.0, random.nextDouble(), 1.0, this);
            } else if (modulationSource == ModulationSource.LFO3) {
                controls.getControl("lfo3-variable-waveform").set(0.0, random.nextDouble(), 1.0, this);
                controls.getControl("lfo3-frequency").set(0.0, random.nextDouble(), 1.0, this);
            }
            Control depth = modulationMatrix.add(modulationSource, modulationTargets.get((int)(Math.random() * (double)(modulationTargets.size() - 1))));
            depth.set(0.0, random.nextDouble(), 1.0, this);
        }
    }

    private int random(int ... values) {
        return values[(int)(Math.random() * (double)values.length)];
    }

    private double random(double ... values) {
        return values[(int)(Math.random() * (double)values.length)];
    }

    private void randomize(DiscreteControl discreteControl) {
        discreteControl.set(discreteControl.getAllowedValues().get((int)(Math.random() * (double)(discreteControl.getAllowedValues().size() - 1))), this);
    }
}

