/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.jevring.frequencies.v2.configuration.StoredConfigurationCallback;

public class ConfigurationReader {
    public static void read(InputStream inputStream, StoredConfigurationCallback callback) throws IOException {
        String line;
        String section = null;
        String version = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = in.readLine()) != null) {
            if (line.isBlank() || line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                section = line.substring(1, line.length() - 1);
                continue;
            }
            if ("version".equals(section)) {
                if (version != null) {
                    throw new IllegalArgumentException("Cannot have version specified more than once");
                }
                version = line;
                continue;
            }
            callback.handle(version, section, line);
        }
        callback.loadComplete();
    }

    public static void read(File file, StoredConfigurationCallback callback) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            ConfigurationReader.read(fis, callback);
        }
    }
}

