/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.curves.Curve;
import net.jevring.frequencies.v2.control.curves.Exponential;
import net.jevring.frequencies.v2.control.curves.Linear;
import net.jevring.frequencies.v2.control.curves.Logarithmic;
import net.jevring.frequencies.v2.math.Interpolation;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;

public class JSliderControl
extends JPanel {
    private static final int SLIDER_MIN = 0;
    private static final int SLIDER_MAX = 1000000;
    private final JLabel label;
    private final JSlider slider;
    private final JComboBox<Curve> curveSelector;
    private final JFormattedTextField min;
    private final JFormattedTextField max;
    private final JLabel value;
    private volatile Control control;

    public JSliderControl(String label, double min, double current, double max, Class<? extends Curve> curve) {
        super(new GridBagLayout());
        this.label = new JLabel(label, 0);
        Curve[] curves = new Curve[]{new Linear(), new Logarithmic(), new Exponential()};
        this.curveSelector = new JComboBox<Curve>(curves);
        this.curveSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && JSliderControl.this.control != null) {
                    Curve curve = (Curve)e.getItem();
                }
            }
        });
        this.curveSelector.setSelectedItem(Arrays.stream(curves).filter(c -> c.getClass().equals(curve)).findFirst().orElseThrow());
        this.slider = new JSlider(1, 0, 1000000, (int)this.domainToSlider(min, current, max));
        this.slider.setPreferredSize(new Dimension(25, 100));
        this.min = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.min.setHorizontalAlignment(0);
        this.min.setValue(min);
        this.max = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.max.setHorizontalAlignment(0);
        this.max.setValue(max);
        this.value = new JLabel(String.format("%.4f", current));
        this.value.setMinimumSize(new Dimension(25, 0));
        this.value.setText(String.format("%.4f", current));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = JSliderControl.this.slider.getValue();
                double valueScaledToDomain = JSliderControl.this.sliderToDomain(JSliderControl.this.minValue(), value, JSliderControl.this.maxValue());
                JSliderControl.this.value.setText(String.format("%.4f", valueScaledToDomain));
                if (JSliderControl.this.control != null) {
                    JSliderControl.this.control.set(0.0, JSliderControl.this.slider.getValue(), 1000000.0, JSliderControl.this);
                }
            }
        });
        this.add((Component)this.label, GridBadLayoutUtils.gbc(0, 0, 2, 1, 0.0, 0.0));
        this.add(this.curveSelector, GridBadLayoutUtils.gbc(0, 1, 2, 1, 0.0, 0.0));
        this.add((Component)this.max, GridBadLayoutUtils.gbc(0, 2, 2, 1, 0.0, 0.0));
        this.add((Component)this.slider, GridBadLayoutUtils.gbc(0, 3, 1, 1, 0.0, 10.0));
        this.add((Component)this.value, GridBadLayoutUtils.gbc(1, 3, 1, 1, 0.0, 10.0));
        this.add((Component)this.min, GridBadLayoutUtils.gbc(0, 4, 2, 1, 0.0, 0.0));
    }

    private double domainToSlider(double min, double value, double max) {
        return Interpolation.linear(min, max, value, 0.0, 1000000.0);
    }

    private double sliderToDomain(double min, double value, double max) {
        return Interpolation.linear(0.0, 1000000.0, value, min, max);
    }

    public void attachControl(Control control) {
        this.control = control;
        this.control.addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                if (source == JSliderControl.this) {
                    return;
                }
                double valueScaledToSlider = JSliderControl.this.domainToSlider(min, newValue, max);
                System.out.printf("slider: %13.5f = %13.5f, %s%n", newValue, valueScaledToSlider, source);
                JSliderControl.this.slider.setValue((int)valueScaledToSlider);
            }
        });
    }

    public double minValue() {
        Number minValue = (Number)this.min.getValue();
        return minValue.doubleValue();
    }

    public double maxValue() {
        Number maxValue = (Number)this.max.getValue();
        System.out.println("maxValue = " + maxValue);
        return maxValue.doubleValue();
    }
}

