/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JComponent;
import net.jevring.frequencies.v2.ui.JSkinnable;
import net.jevring.frequencies.v2.ui.Skin;
import net.jevring.frequencies.v2.ui.Skins;
import net.jevring.frequencies.v2.util.Bytes;

public class ByteArrayGraph
extends JComponent
implements JSkinnable {
    private static final boolean ALIGN = true;
    private final int maxXAxis = 600;
    private final int yOffset = 150;
    private final int xOffset = 5;
    private byte[] data = null;
    private int bitsPerSample = 8;
    private volatile Skin skin = Skins.defaultSkin();

    public ByteArrayGraph() {
        Dimension size = new Dimension(605, 300);
        this.setPreferredSize(size);
        this.setSize(size);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setAlignmentX(0.0f);
    }

    @Override
    public void setSkin(Skin skin) {
        this.skin = skin;
        this.repaint();
    }

    public void update(byte[] data, int bitsPerSample) {
        this.bitsPerSample = bitsPerSample;
        this.data = data;
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.skin.foreground());
        g.drawLine(5, 15, 5, 285);
        g.drawLine(5, 150, 605, 150);
        if (this.data != null) {
            int i;
            Polygon p = new Polygon();
            int x = 5;
            int bytesPerSample = this.bitsPerSample / 8;
            int previousValue = Integer.MIN_VALUE;
            boolean startingPointFound = false;
            for (i = 0; i < this.data.length; i += bytesPerSample) {
                int value = Bytes.convertToInt(this.data, i, bytesPerSample);
                if (!startingPointFound && previousValue != Integer.MIN_VALUE && Math.signum(previousValue) != Math.signum(value) && (double)(value - previousValue) < 0.1 || value == 0) {
                    startingPointFound = true;
                }
                previousValue = value;
                if (startingPointFound) {
                    value = (int)Math.round((double)value / Math.pow(2.0, this.bitsPerSample) * 255.0);
                    p.addPoint(x, 150 - value);
                    ++x;
                }
                if (x >= 600) break;
            }
            g.setColor(this.skin.modulationRange());
            g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
            g.setColor(this.skin.modulationValue());
            for (i = 0; i < p.npoints; ++i) {
                g.drawRect(p.xpoints[i], p.ypoints[i], 1, 1);
            }
        }
    }
}

