/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.tests;

import java.util.concurrent.TimeUnit;
import net.jevring.frequencies.v2.waveforms.SineWaveform;
import net.jevring.frequencies.v2.waveforms.Waveform;

@Deprecated
public class SpinningOscillator {
    private Thread thread;
    private volatile boolean running = false;
    private volatile double frequency;
    private volatile Waveform waveform;
    private volatile double value = 0.0;

    public SpinningOscillator(double frequency, Waveform waveform) {
        this.frequency = frequency;
        this.waveform = waveform;
    }

    public static void main(String[] args) {
        SpinningOscillator spinningOscillator = new SpinningOscillator(1.0, new SineWaveform());
        spinningOscillator.start();
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public Waveform getWaveform() {
        return this.waveform;
    }

    public void setWaveform(Waveform waveform) {
        this.waveform = waveform;
    }

    public double currentValue() {
        return this.value;
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new IllegalStateException("Already running");
        }
        this.running = true;
        this.thread = new Thread(this::loop);
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread == null) {
            throw new IllegalStateException("Not running");
        }
        this.running = false;
        this.thread.interrupt();
        this.thread = null;
    }

    private void loop() {
        double nanosecondsPerSecond = TimeUnit.SECONDS.toNanos(1L);
        double cycleProgress = 0.0;
        long previousNanos = System.nanoTime();
        while (this.running) {
            long nowNanos = System.nanoTime();
            long elapsedNanos = nowNanos - previousNanos;
            if ((double)elapsedNanos > 1.0E7) {
                previousNanos = nowNanos;
                double nanosecondsPerCycle = nanosecondsPerSecond / this.frequency;
                double elapsedCycles = (double)elapsedNanos / nanosecondsPerCycle;
                cycleProgress += elapsedCycles;
                this.value = this.waveform.valueAt(cycleProgress %= 1.0, 0.0, true, 0, 0.0);
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

