/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.tests;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.jevring.frequencies.v1.tests.MutableDouble;
import net.jevring.frequencies.v2.waveforms.Waveform;

@Deprecated
public class SignalOscillator {
    private final MutableDouble value;
    private volatile Waveform waveform;
    private volatile MutableDouble modulationSize;
    private volatile MutableDouble frequency;
    private volatile boolean running = false;

    public SignalOscillator(MutableDouble value, Waveform waveform, MutableDouble modulationSize, MutableDouble frequency) {
        this.value = value;
        this.waveform = waveform;
        this.modulationSize = modulationSize;
        this.frequency = frequency;
    }

    public void start() {
        this.running = true;
        new Thread(this::loop).start();
    }

    private void loop() {
        TimeUnit timeUnit = TimeUnit.NANOSECONDS;
        System.out.println("frequency.get() = " + this.frequency.get());
        double samplesPerSecond = 10.0;
        double samplesPerPeriod = samplesPerSecond / this.frequency.get();
        double stepSizeInPercent = 1.0 / samplesPerPeriod;
        long timeUnitsPerSecond = timeUnit.convert(Duration.ofSeconds(1L));
        long pause = Math.round((double)timeUnitsPerSecond / samplesPerSecond);
        long lastReset = System.currentTimeMillis();
        double cycleProgress = 0.0;
        long sleepAdjustment = 0L;
        while (this.running) {
            long stepStart = System.nanoTime();
            this.value.set(this.waveform.valueAt(cycleProgress += stepSizeInPercent, 0.0, true, 0, 0.0) * this.modulationSize.get());
            if (cycleProgress >= 1.0) {
                long now = System.currentTimeMillis();
                System.out.println("reset after " + (now - lastReset) + " ms");
                lastReset = now;
                cycleProgress %= 1.0;
            }
            try {
                timeUnit.sleep(pause + sleepAdjustment);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            long stepEnd = System.nanoTime();
            long stepTotal = stepEnd - stepStart;
            long stepTotalInCorrectUnit = timeUnit.convert(stepTotal, TimeUnit.NANOSECONDS);
            sleepAdjustment = pause - stepTotalInCorrectUnit;
        }
    }
}

