/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.tests;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jevring.frequencies.v1.tests.MutableDouble;
import net.jevring.frequencies.v1.tests.SignalOscillator;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;
import net.jevring.frequencies.v2.ui.SwingUtils;
import net.jevring.frequencies.v2.util.Bytes;
import net.jevring.frequencies.v2.waveforms.SawtoothWaveform;
import net.jevring.frequencies.v2.waveforms.SineWaveform;
import net.jevring.frequencies.v2.waveforms.SquareWaveform;
import net.jevring.frequencies.v2.waveforms.TriangleWaveform;
import net.jevring.frequencies.v2.waveforms.Waveform;

public class MainLoopOscillator {
    private static final float SAMPLE_RATE = 44100.0f;
    private static final float SAMPLE_SIZE_IN_BITS = 16.0f;
    private Thread thread;
    private volatile boolean running = false;
    private SourceDataLine sourceDataLine;
    private volatile short volume = Short.MAX_VALUE;
    private volatile double frequency = 440.0;
    private volatile Waveform waveform = new SineWaveform();

    public MainLoopOscillator() {
        final JSlider frequency = new JSlider(100, 600, 440);
        frequency.setPreferredSize(new Dimension(1000, 25));
        final JTextField frequencyValue = new JTextField(frequency.getValue() + " Hz");
        frequency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainLoopOscillator.this.frequency = frequency.getValue();
                frequencyValue.setText(frequency.getValue() + " Hz");
            }
        });
        final JComboBox<Waveform> waveforms = new JComboBox<Waveform>(new Waveform[]{new SineWaveform(), new SawtoothWaveform(true), new SquareWaveform(), new TriangleWaveform()});
        waveforms.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainLoopOscillator.this.waveform = (Waveform)waveforms.getSelectedItem();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.add((Component)frequency, GridBadLayoutUtils.gbc(0, 1, 1, 1, 1.0, 0.0));
        mainPanel.add((Component)frequencyValue, GridBadLayoutUtils.gbc(1, 1, 1, 1, 0.0, 0.0));
        SwingUtils.showWindowFor("Frequency", mainPanel, false);
    }

    public static void main(String[] args) throws LineUnavailableException {
        MainLoopOscillator mainLoopOscillator = new MainLoopOscillator();
        mainLoopOscillator.start();
    }

    private void startFrequencyModulator(int by) {
        SignalOscillator signalOscillator = new SignalOscillator(new MutableDouble(){

            @Override
            public double get() {
                return MainLoopOscillator.this.frequency;
            }

            @Override
            public void set(double d) {
                MainLoopOscillator.this.frequency = 440.0 + d;
            }
        }, new SineWaveform(), MutableDouble.fixed(by), MutableDouble.fixed(2.0));
        signalOscillator.start();
    }

    private void loop() {
        double cycleProgress = 0.0;
        long s = System.currentTimeMillis();
        int i = 0;
        while (this.running) {
            double samplesPerPeriod = 44100.0 / this.frequency;
            double stepSizeInPercent = 1.0 / samplesPerPeriod;
            cycleProgress += stepSizeInPercent;
            double waveformValueAtPeriod = this.waveform.valueAt(cycleProgress %= 1.0, 0.0, true, 0, 0.0);
            short sample = (short)(waveformValueAtPeriod * (double)this.volume);
            this.sourceDataLine.write(Bytes.convertToBytes(sample, 2), 0, 2);
            ++i;
            long now = System.currentTimeMillis();
            if (now - s <= 1000L) continue;
            System.out.println("i = " + i);
            i = 0;
            s = now;
        }
    }

    private synchronized void start() throws LineUnavailableException {
        if (this.thread != null) {
            throw new IllegalStateException("Already running");
        }
        this.running = true;
        this.thread = new Thread(this::loop);
        AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, true);
        this.sourceDataLine = AudioSystem.getSourceDataLine(format);
        this.sourceDataLine.open(format);
        this.sourceDataLine.start();
        this.thread.start();
    }

    private synchronized void stop() {
        if (this.thread == null) {
            throw new IllegalStateException("Not running");
        }
        this.running = false;
        this.sourceDataLine.flush();
        this.sourceDataLine.close();
        this.thread = null;
    }
}

