/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.sound;

import javax.sound.sampled.AudioFormat;
import net.jevring.frequencies.v1.waveforms.Waveform;

public class FixedSound {
    protected final Waveform waveform;
    private final long milliseconds;
    private final byte[] data;

    public FixedSound(Waveform waveform, long milliseconds) {
        this.waveform = waveform;
        this.milliseconds = milliseconds;
        if (milliseconds < 0L) {
            throw new IllegalArgumentException("Duration must be > 0");
        }
        this.data = this.generateSound();
    }

    public byte[] getData() {
        return this.data;
    }

    public float getSampleRate() {
        return this.waveform.getSampleRate();
    }

    public int getBitsPerSample() {
        return this.waveform.getBitsPerSample();
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public AudioFormat getAudioFormat() {
        return this.waveform.getAudioFormat();
    }

    protected byte[] generateSound() {
        int bytesPerSample = this.getBitsPerSample() / 8;
        byte[] data = new byte[(int)((double)(this.getSampleRate() * (float)bytesPerSample * (float)this.milliseconds) / 1000.0)];
        for (int i = 0; i < data.length; i += bytesPerSample) {
            int value = this.waveform.valueAtStep(i);
            if (this.getBitsPerSample() == 8) {
                data[i] = (byte)value;
                continue;
            }
            if (this.getBitsPerSample() != 16) continue;
            data[i + 1] = (byte)(value & 0xFF);
            data[i] = (byte)(value >> 8 & 0xFF);
        }
        return data;
    }
}

