/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.output;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.jevring.frequencies.v1.sound.Signal;

public class LineOutput {
    private Signal signal;
    private SourceDataLine sourceDataLine;
    private volatile boolean stopped = false;

    public void connect(Signal signal) {
        this.signal = signal;
    }

    public void play() throws LineUnavailableException {
        byte[] sound;
        AudioFormat format = this.signal.getAudioFormat();
        this.sourceDataLine = AudioSystem.getSourceDataLine(format);
        this.sourceDataLine.open(format);
        this.sourceDataLine.start();
        this.stopped = false;
        while ((sound = this.signal.getSound()) != null && !this.stopped) {
            this.sourceDataLine.write(sound, 0, sound.length);
        }
    }

    public void stop() {
        this.stopped = true;
        this.sourceDataLine.flush();
        this.sourceDataLine.close();
    }
}

