/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.continuous.signals;

import net.jevring.frequencies.v1.continuous.ValueProvider;
import net.jevring.frequencies.v1.sound.FixedSound;
import net.jevring.frequencies.v1.sound.Signal;
import net.jevring.frequencies.v1.waveforms.sine.SineWaveform;

public class FrequencyModulatedSineWaveSignal
extends FixedSound
implements Signal {
    private ValueProvider frequencyModulator;

    public FrequencyModulatedSineWaveSignal(int sampleRate, int bitsPerSample, int frequency) {
        super(new SineWaveform(sampleRate, bitsPerSample, frequency), 0L);
    }

    public void setFrequencyModulator(ValueProvider frequencyModulator) {
        this.frequencyModulator = frequencyModulator;
    }

    private double getFrequency() {
        return (double)this.waveform.getFrequency() + this.frequencyModulator.getValue();
    }

    @Override
    public byte[] getSound() {
        int bytesPerSample = this.waveform.getBitsPerSample() / 8;
        byte[] data = new byte[(int)(Math.floor((double)this.waveform.getSampleRate() / this.getFrequency()) * (double)bytesPerSample)];
        for (int i = 0; i < data.length; i += bytesPerSample) {
            double angle = (double)i / ((double)this.waveform.getSampleRate() / this.getFrequency()) * 2.0 * Math.PI;
            int value = (int)(Math.sin(angle /= (double)bytesPerSample) * (Math.pow(2.0, this.waveform.getBitsPerSample() - 1) - 1.0));
            if (this.waveform.getBitsPerSample() == 8) {
                data[i] = (byte)value;
                continue;
            }
            if (this.waveform.getBitsPerSample() != 16) continue;
            data[i + 1] = (byte)(value & 0xFF);
            data[i] = (byte)(value >> 8 & 0xFF);
        }
        return data;
    }
}

