/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.thief;

import java.util.List;
import net.jevring.frequencies.v2.hooks.Visualizer;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modulation.SidedDepth;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrix;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrixVoice;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;
import net.jevring.thief.ThiefUI;

public class ThiefUIVisualizer
implements Visualizer {
    private final ModulationMatrix modulationMatrix;
    private final ThiefUI thiefUI;

    public ThiefUIVisualizer(ModulationMatrix modulationMatrix, ThiefUI thiefUI) {
        this.modulationMatrix = modulationMatrix;
        this.thiefUI = thiefUI;
    }

    @Override
    public void visualizeModulation(int samplesToGenerate, List<Instruction> instructions) {
        double youngestAge = 9.223372036854776E18;
        int youngestVoice = 0;
        Instruction youngestInstruction = null;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            if (instruction == null || !((double)instruction.getAge() < youngestAge)) continue;
            youngestVoice = i;
            youngestAge = instruction.getAge();
            youngestInstruction = instruction;
        }
        ModulationMatrixVoice representativeVoiceForModulation = this.modulationMatrix.voice(youngestVoice);
        for (ModulationTarget modulationTarget : ModulationTarget.values()) {
            SidedDepth modulationMaxForTarget = representativeVoiceForModulation.getModulationMaxForTarget(modulationTarget);
            if (modulationMaxForTarget == null) continue;
            double representativeModulationValue = representativeVoiceForModulation.getModulationForTarget(modulationTarget, samplesToGenerate, youngestInstruction)[0];
            this.thiefUI.visualizedCurrentModulation(modulationTarget, modulationMaxForTarget, representativeModulationValue);
        }
    }

    @Override
    public void visualizeLoopTime(double percentageOfMax) {
        this.thiefUI.visualizeLoopTime(percentageOfMax);
    }

    @Override
    public void visualizeWaveformChunk(double[] samples) {
        this.thiefUI.visualizeNewWaveformChunk(samples);
    }
}

