/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.thief;

import java.awt.Component;
import java.awt.Font;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.jevring.frequencies.v2.configuration.Configuration;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.input.Sequencer;
import net.jevring.frequencies.v2.input.midi.MidiManager;
import net.jevring.frequencies.v2.input.midi.MidiReceiver;
import net.jevring.frequencies.v2.modulation.SidedDepth;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;
import net.jevring.frequencies.v2.output.Device;
import net.jevring.frequencies.v2.ui.FontSupport;
import net.jevring.frequencies.v2.ui.JDelayPanel;
import net.jevring.frequencies.v2.ui.JEnvelopePanel;
import net.jevring.frequencies.v2.ui.JFilterPanel;
import net.jevring.frequencies.v2.ui.JInputPanel;
import net.jevring.frequencies.v2.ui.JKeyboardPanel;
import net.jevring.frequencies.v2.ui.JMiniWaveformDisplay;
import net.jevring.frequencies.v2.ui.JMixerPanel;
import net.jevring.frequencies.v2.ui.JModulationDisplay;
import net.jevring.frequencies.v2.ui.JModulationMatrix;
import net.jevring.frequencies.v2.ui.JOscillatorPanel;
import net.jevring.frequencies.v2.ui.JReverbPanel;
import net.jevring.frequencies.v2.ui.JTempoPanel;
import net.jevring.frequencies.v2.ui.KeyboardInput;
import net.jevring.frequencies.v2.ui.LFOPanel;
import net.jevring.frequencies.v2.ui.MidiMapperGlassPane;
import net.jevring.frequencies.v2.ui.SampleAndHoldPanel;
import net.jevring.frequencies.v2.ui.Skin;
import net.jevring.frequencies.v2.ui.Skins;
import net.jevring.frequencies.v2.ui.SwingUtils;
import net.jevring.thief.Thief;

public class ThiefUI
extends JPanel {
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, runnable -> {
        Thread thread = new Thread(runnable, "ui-stats-scheduler");
        thread.setDaemon(true);
        return thread;
    });
    private final Map<ModulationTarget, JModulationDisplay> modulationDisplays = new HashMap<ModulationTarget, JModulationDisplay>();
    private final JMiniWaveformDisplay miniWaveformDisplay;
    private final JLabel loopTimeLabel = new JLabel("000000");
    private final JLabel cpuLabel = new JLabel("0.00%");
    private final JModulationMatrix jModulationMatrix;
    private final Configuration configuration;
    private final Controls controls;
    private final Thief thief;
    private final JTempoPanel tempoPanel;
    private volatile JFrame window;

    public ThiefUI(Thief thief) {
        this.jModulationMatrix = new JModulationMatrix(thief.getModulationMatrix());
        this.miniWaveformDisplay = new JMiniWaveformDisplay();
        this.configuration = thief.getConfiguration();
        this.controls = thief.getControls();
        this.tempoPanel = new JTempoPanel(this.controls);
        this.thief = thief;
        this.createUI();
        SwingUtilities.invokeLater(() -> {
            HashMap<String, JModulationDisplay> modulationDisplaysByControlName = new HashMap<String, JModulationDisplay>();
            this.enumerateJModulationDisplays(this, modulationDisplaysByControlName);
            this.modulationDisplays.put(ModulationTarget.FILTER_CUTOFF_FREQUENCY, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("filter-cutoff-frequency")));
            this.modulationDisplays.put(ModulationTarget.FILTER_RESONANCE, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("q-resonance-emphasis")));
            this.modulationDisplays.put(ModulationTarget.PRIMARY_OSCILLATOR_DETUNE, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("primary-oscillator-detune-semi-tones")));
            this.modulationDisplays.put(ModulationTarget.PRIMARY_OSCILLATOR_VOLUME, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("primary-oscillator-volume")));
            this.modulationDisplays.put(ModulationTarget.PRIMARY_OSCILLATOR_OCTAVE, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("primary-oscillator-octave-offset")));
            this.modulationDisplays.put(ModulationTarget.PRIMARY_OSCILLATOR_PHASE_SHIFT, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("primary-oscillator-phase-shift")));
            this.modulationDisplays.put(ModulationTarget.PRIMARY_OSCILLATOR_WAVE_SHAPE, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("primary-oscillator-wave-shape")));
            this.modulationDisplays.put(ModulationTarget.PRIMARY_OSCILLATOR_QUANTIZATION_STEPS, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("primary-oscillator-quantization-steps")));
            this.modulationDisplays.put(ModulationTarget.PRIMARY_OSCILLATOR_WAVEFORM_VARIATION, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("primary-oscillator-variable-waveform")));
            this.modulationDisplays.put(ModulationTarget.SECONDARY_OSCILLATOR_DETUNE, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("secondary-oscillator-detune-semi-tones")));
            this.modulationDisplays.put(ModulationTarget.SECONDARY_OSCILLATOR_VOLUME, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("secondary-oscillator-volume")));
            this.modulationDisplays.put(ModulationTarget.SECONDARY_OSCILLATOR_OCTAVE, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("secondary-oscillator-octave-offset")));
            this.modulationDisplays.put(ModulationTarget.SECONDARY_OSCILLATOR_PHASE_SHIFT, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("secondary-oscillator-phase-shift")));
            this.modulationDisplays.put(ModulationTarget.SECONDARY_OSCILLATOR_WAVE_SHAPE, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("secondary-oscillator-wave-shape")));
            this.modulationDisplays.put(ModulationTarget.SECONDARY_OSCILLATOR_QUANTIZATION_STEPS, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("secondary-oscillator-quantization-steps")));
            this.modulationDisplays.put(ModulationTarget.SECONDARY_OSCILLATOR_WAVEFORM_VARIATION, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("secondary-oscillator-variable-waveform")));
            this.modulationDisplays.put(ModulationTarget.NOISE_OSCILLATOR_VOLUME, Objects.requireNonNull((JModulationDisplay)modulationDisplaysByControlName.get("noise-oscillator-volume")));
        });
        SCHEDULER.scheduleAtFixedRate(new Runnable(){
            private final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();

            @Override
            public void run() {
                try {
                    ObjectName operatingSystemName = ObjectName.getInstance("java.lang:type=OperatingSystem");
                    Double processCpuLoad = (Double)this.platformMBeanServer.getAttribute(operatingSystemName, "ProcessCpuLoad");
                    if (processCpuLoad != null && processCpuLoad > 0.0) {
                        String load = String.format(Locale.US, " cpu: %-3.2f%%", processCpuLoad * 100.0);
                        SwingUtilities.invokeLater(() -> ThiefUI.this.cpuLabel.setText(load));
                    }
                }
                catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                    e.printStackTrace();
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        final KeyboardInput keyboardInput = new KeyboardInput(thief.getKeyTimings());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                    @Override
                    public boolean dispatchKeyEvent(KeyEvent e) {
                        if (e.getKeyChar() != '\uffff') {
                            if (e.getID() == 401) {
                                keyboardInput.keyPressed(e);
                            } else if (e.getID() == 402) {
                                keyboardInput.keyReleased(e);
                            }
                        }
                        return false;
                    }
                });
            }
        });
    }

    public JFrame displayUI(Consumer<Device> restartThiefWithNewDevice) {
        this.window = SwingUtils.showWindowFor("Thief v1.4", this, true);
        this.configureMenu(this.window, restartThiefWithNewDevice);
        this.jModulationMatrix.modulationMatrixUpdated();
        return this.window;
    }

    public void setBackgroundImage(String resourceImagePath) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!"Background".equals(component.getName())) continue;
            this.remove(i);
            break;
        }
        if (resourceImagePath != null) {
            try {
                InputStream backgroundImageInputStream = ThiefUI.class.getResourceAsStream(resourceImagePath);
                BufferedImage bg = ImageIO.read(backgroundImageInputStream);
                JLabel bgLabel = new JLabel(new ImageIcon(bg));
                bgLabel.setName("Background");
                this.add(bgLabel).setBounds(0, 0, bg.getWidth(), bg.getHeight());
                this.setComponentZOrder(bgLabel, this.getComponentCount() - 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void createUI() {
        SwingUtilities.invokeLater(() -> {
            this.setLayout(null);
            this.add(new LFOPanel(this.controls, "lfo1")).setBounds(0, 0, 145, 210);
            this.add(new LFOPanel(this.controls, "lfo2")).setBounds(145, 0, 145, 210);
            this.add(new LFOPanel(this.controls, "lfo3")).setBounds(290, 0, 145, 210);
            this.add(new SampleAndHoldPanel(this.controls)).setBounds(435, 0, 130, 210);
            this.add(this.jModulationMatrix).setBounds(0, 210, 565, 365);
            this.add(new JOscillatorPanel(this.controls, "primary-oscillator")).setBounds(565, 0, 200, 275);
            this.add(new JOscillatorPanel(this.controls, "secondary-oscillator")).setBounds(565, 275, 200, 300);
            this.add(new JMixerPanel(this.controls)).setBounds(765, 0, 70, 575);
            this.add(new JEnvelopePanel(this.controls, this.thief.getEnvelopes(), "volume")).setBounds(835, 0, 250, 140);
            this.add(new JEnvelopePanel(this.controls, this.thief.getEnvelopes(), "filter")).setBounds(835, 140, 250, 140);
            this.add(new JEnvelopePanel(this.controls, this.thief.getEnvelopes(), "modulation")).setBounds(835, 280, 250, 140);
            this.add(new JFilterPanel(this.controls)).setBounds(835, 420, 250, 155);
            this.add(new JDelayPanel(this.controls)).setBounds(1085, 0, 230, 110);
            this.add(new JReverbPanel(this.controls)).setBounds(1085, 110, 230, 110);
            this.add(new JInputPanel(this.controls)).setBounds(1085, 220, 230, 110);
            this.add(this.miniWaveformDisplay).setBounds(1085, 440, 230, 135);
            this.add(this.tempoPanel).setBounds(0, 572, 1315, 220);
            this.add(new JKeyboardPanel()).setBounds(2, 792, 1081, 20);
            this.add(this.loopTimeLabel).setBounds(1135, 792, 75, 20);
            this.add(this.cpuLabel).setBounds(1210, 792, 75, 20);
        });
    }

    private void configureMenu(final JFrame window, final Consumer<Device> restartThiefWithNewDevice) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMenu fileMenu = ThiefUI.this.createFileMenu(window);
                JMenu midiMenu = ThiefUI.this.createMidiMenu(window);
                JMenu presetsMenu = ThiefUI.this.createPresetsMenu();
                JMenu outputMenu = ThiefUI.this.createOutputMenu(restartThiefWithNewDevice);
                JMenu skinMenu = ThiefUI.this.createSkinMenu();
                JMenuBar mainMenu = new JMenuBar();
                mainMenu.add(fileMenu);
                mainMenu.add(presetsMenu);
                mainMenu.add(midiMenu);
                mainMenu.add(outputMenu);
                mainMenu.add(skinMenu);
                window.setJMenuBar(mainMenu);
            }
        });
    }

    private JMenu createSkinMenu() {
        JMenu skinMenu = this.styleMenuItem(new JMenu("Skin"));
        for (final Skin skin : Skins.skins()) {
            skinMenu.add(this.styleMenuItem(new JMenuItem(skin.name()))).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ThiefUI.this.window != null) {
                        Skins.setSkin(skin, ThiefUI.this.window);
                        if (!skin.opaque()) {
                            ThiefUI.this.setBackgroundImage("/club lasers.jpg");
                        } else {
                            ThiefUI.this.setBackgroundImage(null);
                        }
                    }
                }
            });
        }
        return skinMenu;
    }

    private JMenu createOutputMenu(final Consumer<Device> restartThiefWithNewDevice) {
        JMenu outputMenu = this.styleMenuItem(new JMenu("Outputs"));
        List<Device> supportedSoundDevices = Device.supportedSoundDevices(Thief.AUDIO_FORMAT);
        for (final Device supportedSoundDevice : supportedSoundDevices) {
            outputMenu.add(this.styleMenuItem(new JMenuItem(supportedSoundDevice.describe()))).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    restartThiefWithNewDevice.accept(supportedSoundDevice);
                }
            });
        }
        return outputMenu;
    }

    private JMenu createPresetsMenu() {
        JMenu presetsMenu;
        block9: {
            presetsMenu = this.styleMenuItem(new JMenu("Presets"));
            try {
                URL presets = ThiefUI.class.getResource("/presets");
                URI uri = presets.toURI();
                final HashMap<Path, JMenu> parents = new HashMap<Path, JMenu>();
                SimpleFileVisitor<Path> addPresetToMenu = new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        JMenu menuForParentDirectory = (JMenu)parents.get(dir.getParent());
                        if (menuForParentDirectory != null) {
                            JMenu menuForThisDirectory = ThiefUI.this.styleMenuItem(new JMenu(dir.getFileName().toString()));
                            parents.putIfAbsent(dir, menuForThisDirectory);
                            menuForParentDirectory.add(menuForThisDirectory);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        final String dir = file.getParent().getFileName().toString();
                        final String name = file.getFileName().toString();
                        if (name.endsWith(".conf")) {
                            ((JMenu)parents.get(file.getParent())).add(ThiefUI.this.styleMenuItem(new JMenuItem(name))).addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ThiefUI.this.resetModulation();
                                    ThiefUI.this.configuration.load(ThiefUI.class.getResourceAsStream("/presets/" + dir + "/" + name));
                                    ThiefUI.this.jModulationMatrix.modulationMatrixUpdated();
                                }
                            });
                        }
                        return FileVisitResult.CONTINUE;
                    }
                };
                if ("file".equalsIgnoreCase(uri.getScheme())) {
                    parents.put(Path.of(uri), presetsMenu);
                    Files.walkFileTree(Path.of(uri), (FileVisitor<? super Path>)addPresetToMenu);
                    break block9;
                }
                try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    Path path = fileSystem.getPath("/presets", new String[0]);
                    parents.put(path, presetsMenu);
                    Files.walkFileTree(path, (FileVisitor<? super Path>)addPresetToMenu);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return presetsMenu;
    }

    private JMenu createFileMenu(final JFrame window) {
        JMenuItem resetMenuItem = this.styleMenuItem(new JMenuItem("Reset", 82));
        resetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ThiefUI.this.configuration.reset();
                ThiefUI.this.resetModulation();
            }
        });
        JMenuItem resetSynthesizerMenuItem = this.styleMenuItem(new JMenuItem("Reset synthesizer", 82));
        resetSynthesizerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ThiefUI.this.configuration.resetSynthesizer();
                ThiefUI.this.resetModulation();
            }
        });
        JMenuItem resetSequencerMenuItem = this.styleMenuItem(new JMenuItem("Reset sequencer", 82));
        resetSequencerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ThiefUI.this.configuration.resetSequencer();
            }
        });
        JMenuItem randomizeMenuItem = this.styleMenuItem(new JMenuItem("Randomize", 65));
        randomizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ThiefUI.this.resetModulation();
                ThiefUI.this.configuration.randomize();
                ThiefUI.this.jModulationMatrix.modulationMatrixUpdated();
            }
        });
        JMenuItem randomizeSynthesizerMenuItem = this.styleMenuItem(new JMenuItem("Randomize synthesizer", 65));
        randomizeSynthesizerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ThiefUI.this.resetModulation();
                ThiefUI.this.configuration.randomizeSynthesizer();
                ThiefUI.this.jModulationMatrix.modulationMatrixUpdated();
            }
        });
        JMenuItem randomizeSequencerMenuItem = this.styleMenuItem(new JMenuItem("Randomize sequencer", 65));
        randomizeSequencerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ThiefUI.this.configuration.randomizeSequencer();
            }
        });
        JMenuItem saveMenuItem = this.styleMenuItem(new JMenuItem("Save", 83));
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(ThiefUI.this.configuration.ensureConfigurationDirectoryExists());
                int response = fileChooser.showSaveDialog(window);
                if (response == 0) {
                    ThiefUI.this.configuration.save(fileChooser.getSelectedFile());
                }
            }
        });
        JMenuItem loadMenuItem = this.styleMenuItem(new JMenuItem("Load", 76));
        loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser(ThiefUI.this.configuration.ensureConfigurationDirectoryExists());
                int response = fileChooser.showOpenDialog(window);
                if (response == 0) {
                    try {
                        ThiefUI.this.configuration.load(new FileInputStream(fileChooser.getSelectedFile()));
                        ThiefUI.this.jModulationMatrix.modulationMatrixUpdated();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JMenu fileMenu = this.styleMenuItem(new JMenu("File"));
        fileMenu.add(resetMenuItem);
        fileMenu.add(resetSynthesizerMenuItem);
        fileMenu.add(resetSequencerMenuItem);
        fileMenu.add(randomizeMenuItem);
        fileMenu.add(randomizeSynthesizerMenuItem);
        fileMenu.add(randomizeSequencerMenuItem);
        fileMenu.add(saveMenuItem);
        fileMenu.add(loadMenuItem);
        return fileMenu;
    }

    private <T extends JMenuItem> T styleMenuItem(T menuItem) {
        menuItem.setFont(new Font(FontSupport.PREFERRED_FONT, 0, 12));
        menuItem.setForeground(Skins.currentSkin().foreground());
        menuItem.setBackground(Skins.currentSkin().background());
        return menuItem;
    }

    private JMenu createMidiMenu(final JFrame window) {
        final MidiManager midiManager = this.thief.getMidiManager();
        final JMenu midiDeviceMenu = this.styleMenuItem(new JMenu("Midi device"));
        midiDeviceMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                midiDeviceMenu.removeAll();
                for (final String compatibleDevice : midiManager.getMidiDevices().compatibleDevices()) {
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(compatibleDevice, midiManager.isCurrentDevice(compatibleDevice));
                    midiDeviceMenu.add(ThiefUI.this.styleMenuItem(menuItem)).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (midiManager.isCurrentDevice(compatibleDevice)) {
                                midiManager.disableMidiDevice(compatibleDevice);
                            } else {
                                midiManager.enableMidiDevice(compatibleDevice);
                            }
                        }
                    });
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu midiMappingsMenu = this.styleMenuItem(new JMenu("Midi mappings"));
        midiMappingsMenu.add(this.styleMenuItem(new JMenuItem("Map controls", 67))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MidiMapperGlassPane midiMapperGlassPane = new MidiMapperGlassPane(ThiefUI.this, ThiefUI.this.thief.getMidiManager().getMidiMappings(), window);
                        window.setGlassPane(midiMapperGlassPane);
                        midiMapperGlassPane.setVisible(true);
                    }
                });
            }
        });
        midiMappingsMenu.add(this.styleMenuItem(new JMenuItem("Save midi config", 83))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                midiManager.writeToDefaultFile();
            }
        });
        midiMappingsMenu.add(this.styleMenuItem(new JMenuItem("Save midi config as", 65))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(ThiefUI.this.configuration.ensureConfigurationDirectoryExists());
                int response = fileChooser.showSaveDialog(window);
                if (response == 0) {
                    midiManager.writeToFile(fileChooser.getSelectedFile());
                }
            }
        });
        final MidiReceiver midiReceiver = midiManager.getReceiver();
        final JMenu midiChannelsMenu = this.styleMenuItem(new JMenu("Midi channels (notes)"));
        midiChannelsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                midiChannelsMenu.removeAll();
                midiChannelsMenu.add(ThiefUI.this.styleMenuItem(new JCheckBoxMenuItem("All", midiReceiver.listensOnAllChannels()))).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        midiReceiver.listenOnAllChannels();
                    }
                });
                midiChannelsMenu.add(ThiefUI.this.styleMenuItem(new JCheckBoxMenuItem("None", midiReceiver.listensOnNoChannels()))).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        midiReceiver.listenOnNoChannels();
                    }
                });
                int i = 1;
                while (i <= 16) {
                    final int channel = i++;
                    JCheckBoxMenuItem checkBoxForChannel = new JCheckBoxMenuItem("Channel " + channel, midiReceiver.listensToNotesOnChannel(channel));
                    midiChannelsMenu.add(ThiefUI.this.styleMenuItem(checkBoxForChannel)).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            boolean currentlyListensOnThisChannel = midiReceiver.listensToNotesOnChannel(channel);
                            midiReceiver.listenToNotesOnChannel(channel, !currentlyListensOnThisChannel);
                        }
                    });
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu midiMenu = this.styleMenuItem(new JMenu("Midi"));
        midiMenu.add(midiDeviceMenu);
        midiMenu.add(midiMappingsMenu);
        midiMenu.add(midiChannelsMenu);
        return midiMenu;
    }

    public void resetModulation() {
        for (JModulationDisplay jModulationDisplay : this.modulationDisplays.values()) {
            jModulationDisplay.currentModulation(null, 0.0);
        }
        this.jModulationMatrix.modulationMatrixUpdated();
    }

    private void enumerateJModulationDisplays(JComponent c, Map<String, JModulationDisplay> modulationDisplays) {
        JComponent jComponent = c;
        if (jComponent instanceof JModulationDisplay) {
            JModulationDisplay jmd = (JModulationDisplay)((Object)jComponent);
            modulationDisplays.put(jmd.getControl(), jmd);
        }
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component component = c.getComponent(i);
            Component component2 = component;
            if (!(component2 instanceof JComponent)) continue;
            JComponent jComponent2 = (JComponent)component2;
            this.enumerateJModulationDisplays(jComponent2, modulationDisplays);
        }
    }

    public void visualizedSequencerStep(int step, boolean on) {
        this.tempoPanel.step(step, on);
    }

    public void visualizedSequencerBeat(Sequencer sequencer) {
        this.tempoPanel.beat(sequencer);
    }

    public void visualizedCurrentModulation(ModulationTarget target, SidedDepth depth, double value) {
        JModulationDisplay jModulationDisplay = this.modulationDisplays.get((Object)target);
        if (jModulationDisplay != null) {
            jModulationDisplay.currentModulation(depth, value);
        }
    }

    public void visualizeLoopTime(double percentageOfMax) {
        String labelTest = String.format(Locale.US, "Loop: %03.1f%%", percentageOfMax);
        SwingUtilities.invokeLater(() -> this.loopTimeLabel.setText(labelTest));
    }

    public void visualizeNewWaveformChunk(double[] samples) {
        this.miniWaveformDisplay.newChunk(samples);
    }
}

