/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.voices;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.ExponentialDecayEnvelope;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modular.EnvelopeModule;
import net.jevring.frequencies.v2.modular.OscillatorModule;
import net.jevring.frequencies.v2.modular.ScalingModule;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.oscillators.ControlledOscillator;
import net.jevring.scoundrel.voices.DrumVoice;

public class SimpleTomVoice
implements DrumVoice {
    public static final int NOTE = 64;
    public static final int VOICE_INDEX = 2;
    private final DecayEnvelope volumeEnvelope = new ExponentialDecayEnvelope();
    private final DecayEnvelope pitchEnvelope = new ExponentialDecayEnvelope();
    private final Source chain;

    public SimpleTomVoice(Controls controls, double sampleRate) {
        controls.getControl("simple-tom-volume-envelope-decay").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                SimpleTomVoice.this.volumeEnvelope.setDecayInMillis((long)newValue);
            }
        });
        controls.getControl("simple-tom-pitch-envelope-decay").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                SimpleTomVoice.this.pitchEnvelope.setDecayInMillis((long)newValue);
            }
        });
        EnvelopeModule volumeEnvelopeModule = new EnvelopeModule(this.volumeEnvelope, sampleRate);
        EnvelopeModule pitchEnvelopeModule = new EnvelopeModule(this.pitchEnvelope, sampleRate);
        ControlledOscillator oscillator = new ControlledOscillator("simple-tom", controls, sampleRate, true);
        oscillator.setFrequencyModulationModulationRange(96.0);
        OscillatorModule oscillatorModule = new OscillatorModule(oscillator);
        oscillatorModule.getFrequencyModulation().connect(new AttenuverterModule(controls.getControl("simple-tom-pitch-envelope-modulation-depth"), pitchEnvelopeModule));
        controls.getControl("simple-tom-variable-waveform").set(0.0, 0.0, 3.0, this);
        ScalingModule applyVolumeEnvelope = new ScalingModule(BooleanControl.alwaysTrue());
        applyVolumeEnvelope.setInput(oscillatorModule);
        applyVolumeEnvelope.setScaleInput(volumeEnvelopeModule);
        AttenuverterModule applyLevel = new AttenuverterModule(controls.getControl("simple-tom-level"), applyVolumeEnvelope);
        this.chain = applyLevel;
    }

    @Override
    public double[] samples(Instruction instruction, int samplesToGenerate) {
        return this.chain.generateSamples(samplesToGenerate, instruction);
    }

    @Override
    public void next() {
        this.chain.next();
    }

    @Override
    public Envelope getVolumeEnvelope() {
        return this.volumeEnvelope;
    }

    @Override
    public String getName() {
        return "Tom";
    }

    @Override
    public String getControlPrefix() {
        return "simple-tom";
    }

    @Override
    public int getVoiceIndex() {
        return 2;
    }

    @Override
    public int getInstructionNote() {
        return 64;
    }
}

