/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.voices;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.ExponentialDecayEnvelope;
import net.jevring.frequencies.v2.filters.ControlledFilter;
import net.jevring.frequencies.v2.filters.Filters;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modular.EnvelopeModule;
import net.jevring.frequencies.v2.modular.FilterModule;
import net.jevring.frequencies.v2.modular.NoiseModule;
import net.jevring.frequencies.v2.modular.ScalingModule;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.scoundrel.voices.DrumVoice;

public class OpenHatVoice
implements DrumVoice {
    public static final int NOTE = 67;
    public static final int VOICE_INDEX = 4;
    private final DecayEnvelope volumeEnvelope = new ExponentialDecayEnvelope();
    private final Source chain;

    public OpenHatVoice(Controls controls, double sampleRate, Filters filters) {
        controls.getControl("open-hat-volume-envelope-decay").addRawLongListener(this.volumeEnvelope::setDecayInMillis);
        EnvelopeModule volumeEnvelopeModule = new EnvelopeModule(this.volumeEnvelope, sampleRate);
        NoiseModule noiseModule = new NoiseModule();
        FilterModule filterModule = new FilterModule(new ControlledFilter("open-hat", controls, filters));
        filterModule.setInput(noiseModule);
        ScalingModule applyNoiseEnvelope = new ScalingModule(BooleanControl.alwaysTrue());
        applyNoiseEnvelope.setInput(filterModule);
        applyNoiseEnvelope.setScaleInput(volumeEnvelopeModule);
        AttenuverterModule applyLevel = new AttenuverterModule(controls.getControl("open-hat-level"), applyNoiseEnvelope);
        this.chain = applyLevel;
    }

    @Override
    public double[] samples(Instruction instruction, int samplesToGenerate) {
        return this.chain.generateSamples(samplesToGenerate, instruction);
    }

    @Override
    public void next() {
        this.chain.next();
    }

    @Override
    public Envelope getVolumeEnvelope() {
        return this.volumeEnvelope;
    }

    @Override
    public String getName() {
        return "Open hat";
    }

    @Override
    public String getControlPrefix() {
        return "open-hat";
    }

    @Override
    public int getVoiceIndex() {
        return 4;
    }

    @Override
    public int getInstructionNote() {
        return 67;
    }
}

