/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.voices;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.envelopes.AttackHoldDecayEnvelope;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.ExponentialDecayEnvelope;
import net.jevring.frequencies.v2.filters.ControlledFilter;
import net.jevring.frequencies.v2.filters.Filters;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modular.EnvelopeModule;
import net.jevring.frequencies.v2.modular.FilterModule;
import net.jevring.frequencies.v2.modular.MixerModule;
import net.jevring.frequencies.v2.modular.NoiseModule;
import net.jevring.frequencies.v2.modular.OscillatorModule;
import net.jevring.frequencies.v2.modular.ScalingModule;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.oscillators.Oscillator;
import net.jevring.frequencies.v2.waveforms.QuantizedWaveform;
import net.jevring.frequencies.v2.waveforms.VariableWaveForm;
import net.jevring.scoundrel.voices.DrumVoice;

public class KickVoice
implements DrumVoice {
    public static final int NOTE = 60;
    public static final int VOICE_INDEX = 0;
    private final AttackHoldDecayEnvelope volumeEnvelope = new AttackHoldDecayEnvelope();
    private final DecayEnvelope noiseEnvelope = new ExponentialDecayEnvelope();
    private final DecayEnvelope pitchEnvelope = new ExponentialDecayEnvelope();
    private final Source chain;

    public KickVoice(Controls controls, double sampleRate, Filters filters) {
        this.volumeEnvelope.setAttackInMillis(0L);
        controls.getControl("kick-volume-envelope-hold").addRawLongListener(this.volumeEnvelope::setHoldInMillis);
        controls.getControl("kick-volume-envelope-decay").addRawLongListener(this.volumeEnvelope::setDecayInMillis);
        controls.getControl("kick-pitch-envelope-decay").addRawLongListener(this.pitchEnvelope::setDecayInMillis);
        controls.getControl("kick-noise-envelope-decay").addRawLongListener(this.noiseEnvelope::setDecayInMillis);
        EnvelopeModule volumeEnvelopeModule = new EnvelopeModule(this.volumeEnvelope, sampleRate);
        EnvelopeModule noiseEnvelopeModule = new EnvelopeModule(this.noiseEnvelope, sampleRate);
        EnvelopeModule pitchEnvelopeModule = new EnvelopeModule(this.pitchEnvelope, sampleRate);
        Oscillator oscillator = new Oscillator(sampleRate);
        oscillator.setWaveform(new QuantizedWaveform(new VariableWaveForm()));
        oscillator.setFrequencyModulationModulationRange(96.0);
        OscillatorModule oscillatorModule = new OscillatorModule(oscillator);
        oscillatorModule.getFrequencyModulation().connect(new AttenuverterModule(controls.getControl("kick-pitch-envelope-modulation-depth"), pitchEnvelopeModule));
        controls.getControl("kick-variable-waveform").addRawDoubleListener(oscillator::setWaveformVariation);
        controls.getControl("kick-variable-waveform").set(0.0, 1.0, 3.0, this);
        NoiseModule noiseModule = new NoiseModule();
        FilterModule filterModule = new FilterModule(new ControlledFilter("kick-noise", controls, filters));
        filterModule.setInput(noiseModule);
        filterModule.getCutoffFrequencyModulation().connect(new AttenuverterModule(controls.getControl("kick-noise-filter-envelope-depth"), pitchEnvelopeModule));
        ScalingModule applyVolumeEnvelope = new ScalingModule(BooleanControl.alwaysTrue());
        applyVolumeEnvelope.setInput(oscillatorModule);
        applyVolumeEnvelope.setScaleInput(volumeEnvelopeModule);
        ScalingModule applyNoiseEnvelope = new ScalingModule(BooleanControl.alwaysTrue());
        applyNoiseEnvelope.setInput(filterModule);
        applyNoiseEnvelope.setScaleInput(noiseEnvelopeModule);
        MixerModule lastMixer = new MixerModule();
        lastMixer.add(applyVolumeEnvelope, controls.getControl("kick-waveform-volume"));
        lastMixer.add(applyNoiseEnvelope, controls.getControl("kick-noise-volume"));
        AttenuverterModule applyLevel = new AttenuverterModule(controls.getControl("kick-level"), lastMixer);
        this.chain = applyLevel;
    }

    @Override
    public double[] samples(Instruction instruction, int samplesToGenerate) {
        return this.chain.generateSamples(samplesToGenerate, instruction);
    }

    @Override
    public void next() {
        this.chain.next();
    }

    @Override
    public Envelope getVolumeEnvelope() {
        return this.volumeEnvelope;
    }

    @Override
    public String getName() {
        return "Kick";
    }

    @Override
    public String getControlPrefix() {
        return "kick";
    }

    @Override
    public int getVoiceIndex() {
        return 0;
    }

    @Override
    public int getInstructionNote() {
        return 60;
    }
}

