/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.voices;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.ExponentialDecayEnvelope;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modular.EnvelopeModule;
import net.jevring.frequencies.v2.modular.OscillatorModule;
import net.jevring.frequencies.v2.modular.ScalingModule;
import net.jevring.frequencies.v2.modular.Source;
import net.jevring.frequencies.v2.oscillators.Oscillator;
import net.jevring.frequencies.v2.waveforms.SineWaveform;
import net.jevring.scoundrel.voices.DrumVoice;

public class ClaveVoice
implements DrumVoice {
    public static final int NOTE = 71;
    public static final int VOICE_INDEX = 6;
    private final DecayEnvelope volumeEnvelope = new ExponentialDecayEnvelope();
    private final Source chain;

    public ClaveVoice(Controls controls, double sampleRate) {
        controls.getControl("clave-volume-envelope-decay").addRawLongListener(this.volumeEnvelope::setDecayInMillis);
        EnvelopeModule volumeEnvelopeModule = new EnvelopeModule(this.volumeEnvelope, sampleRate);
        Oscillator oscillator = new Oscillator(sampleRate);
        oscillator.setWaveform(new SineWaveform());
        OscillatorModule oscillatorModule = new OscillatorModule(oscillator);
        ScalingModule applyVolumeEnvelope = new ScalingModule(BooleanControl.alwaysTrue());
        applyVolumeEnvelope.setInput(oscillatorModule);
        applyVolumeEnvelope.setScaleInput(volumeEnvelopeModule);
        AttenuverterModule applyLevel = new AttenuverterModule(controls.getControl("clave-level"), applyVolumeEnvelope);
        this.chain = applyLevel;
    }

    @Override
    public double[] samples(Instruction instruction, int samplesToGenerate) {
        return this.chain.generateSamples(samplesToGenerate, instruction);
    }

    @Override
    public void next() {
        this.chain.next();
    }

    @Override
    public Envelope getVolumeEnvelope() {
        return this.volumeEnvelope;
    }

    @Override
    public String getName() {
        return "Claves";
    }

    @Override
    public String getControlPrefix() {
        return "clave";
    }

    @Override
    public int getVoiceIndex() {
        return 6;
    }

    @Override
    public int getInstructionNote() {
        return 71;
    }
}

