/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.hooks.SequencerVisualizer;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.Sequencer;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;
import net.jevring.frequencies.v2.ui.JControlledCheckBox;
import net.jevring.frequencies.v2.ui.JControlledTextIconButton;
import net.jevring.frequencies.v2.ui.JInstantPad;
import net.jevring.frequencies.v2.ui.JKnob;
import net.jevring.frequencies.v2.ui.JSequencerPad;
import net.jevring.frequencies.v2.util.ValueFormatter;
import net.jevring.scoundrel.voices.DrumVoice;

public class JScoundrelSequencer
extends JPanel
implements SequencerVisualizer {
    private final JControlledTextIconButton startSequencerButton;
    private final JSequencerPad[][] sequencerStepPads;

    public JScoundrelSequencer(Controls controls, DrumVoice[] voices, KeyTimings keyTimings) {
        this.sequencerStepPads = new JSequencerPad[16][voices.length];
        this.startSequencerButton = new JControlledTextIconButton('\u25b6', controls.getBooleanControl("sequencer-active"), true);
        JControlledCheckBox midiClockIn = new JControlledCheckBox("MIDI Clock IN", controls.getBooleanControl("receive-midi-clock-active"));
        midiClockIn.setHorizontalTextPosition(0);
        midiClockIn.setVerticalTextPosition(3);
        JKnob tempoKnob = new JKnob("Tempo", controls.getControl("tempo"), ValueFormatter.INTEGER);
        this.setLayout(new GridBagLayout());
        for (int instrument = 0; instrument < voices.length; ++instrument) {
            DrumVoice voice = voices[instrument];
            int row = voices.length - instrument;
            this.add((Component)new JLabel(voice.getName()), GridBadLayoutUtils.gbc(0, row));
            String controlPrefix = voice.getControlPrefix();
            this.add((Component)new JInstantPad(keyTimings, voice.getInstructionNote()), GridBadLayoutUtils.gbc(1, row));
            this.add((Component)new JSequencerPad(controls.getBooleanControl(controlPrefix + "-sequencer-mute")), GridBadLayoutUtils.gbc(2, row));
            for (int sequenceStep = 0; sequenceStep < 16; ++sequenceStep) {
                JSequencerPad sequencerStepPad = new JSequencerPad(controls.getBooleanControl(controlPrefix + "-sequencer-enabled-" + sequenceStep));
                this.add((Component)sequencerStepPad, GridBadLayoutUtils.gbc(3 + sequenceStep, row));
                this.sequencerStepPads[sequenceStep][instrument] = sequencerStepPad;
            }
        }
        this.add((Component)tempoKnob, GridBadLayoutUtils.gbc(20, 3, 1, 2));
        this.add((Component)midiClockIn, GridBadLayoutUtils.gbc(20, 5, 2, 1));
        this.add((Component)new JControlledTextIconButton('\u23f9', controls.getBooleanControl("sequencer-active"), false), GridBadLayoutUtils.gbc(20, 6));
        this.add((Component)this.startSequencerButton, GridBadLayoutUtils.gbc(20, 7));
        JLabel hitLabel = new JLabel("Hit");
        hitLabel.setHorizontalAlignment(0);
        this.add((Component)hitLabel, GridBadLayoutUtils.gbc(1, 8));
        JLabel muteLabel = new JLabel("Mute");
        muteLabel.setHorizontalAlignment(0);
        this.add((Component)muteLabel, GridBadLayoutUtils.gbc(2, 8));
        for (int i = 0; i < 16; ++i) {
            JLabel counter = new JLabel(String.valueOf(i + 1));
            counter.setHorizontalAlignment(0);
            this.add((Component)counter, GridBadLayoutUtils.gbc(3 + i, 8));
        }
    }

    @Override
    public void visualizedSequencerStep(int step, boolean on) {
        for (JSequencerPad pad : this.sequencerStepPads[step]) {
            pad.on(on);
        }
    }

    @Override
    public void visualizedSequencerBeat(Sequencer sequencer) {
        this.startSequencerButton.setHighlightOn(!this.startSequencerButton.isHighlightOn());
    }
}

