/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel.input;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.input.AbstractPolyphonicKeySequencer;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.PolyphonicSequencerStep;
import net.jevring.scoundrel.input.DrumVoicePolyphonicSequencerStep;

public class DrumSequencer
extends AbstractPolyphonicKeySequencer<DrumVoicePolyphonicSequencerStep> {
    private final List<Integer> currentlyHighlightedSteps = new ArrayList<Integer>();

    public DrumSequencer(DrumVoicePolyphonicSequencerStep[] sequence, KeyTimings keyTimings, Controls controls, int voices) {
        super((PolyphonicSequencerStep[])sequence, keyTimings, controls, voices);
        controls.getBooleanControl("sequencer-active").addListener(new DiscreteControlListener<Boolean>(){

            @Override
            public void valueChanged(Boolean active, Object source) {
                DrumSequencer.this.setActive(active);
            }
        });
    }

    @Override
    protected void nextCycle() {
    }

    @Override
    protected void visualizeStep(int step) {
        if (this.currentlyHighlightedSteps.size() > 1) {
            System.out.println("There were currently " + this.currentlyHighlightedSteps.size() + " steps highlighted: " + this.currentlyHighlightedSteps);
        }
        Iterator<Integer> iterator = this.currentlyHighlightedSteps.iterator();
        while (iterator.hasNext()) {
            Integer currentlyHighlightedStep = iterator.next();
            iterator.remove();
            this.sequencerVisualizer.visualizedSequencerStep(currentlyHighlightedStep, false);
        }
        this.currentlyHighlightedSteps.add(step);
        this.sequencerVisualizer.visualizedSequencerStep(step, true);
    }

    @Override
    protected void visualizeBeat() {
        this.sequencerVisualizer.visualizedSequencerBeat(this);
    }

    @Override
    protected void setActive(boolean active) {
        super.setActive(active);
        if (this.sequencerVisualizer != null) {
            for (int step = 0; step < 16; ++step) {
                this.sequencerVisualizer.visualizedSequencerStep(step, false);
            }
        }
    }
}

