/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.jevring.frequencies.v2.configuration.Configuration;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.hooks.SequencerVisualizer;
import net.jevring.frequencies.v2.input.midi.MidiManager;
import net.jevring.frequencies.v2.input.midi.MidiReceiver;
import net.jevring.frequencies.v2.output.Device;
import net.jevring.frequencies.v2.ui.FontSupport;
import net.jevring.frequencies.v2.ui.JKnob;
import net.jevring.frequencies.v2.ui.JMiniWaveformDisplay;
import net.jevring.frequencies.v2.ui.JVariableOscillatorKnob;
import net.jevring.frequencies.v2.ui.MidiMapperGlassPane;
import net.jevring.frequencies.v2.ui.Skins;
import net.jevring.frequencies.v2.ui.SwingUtils;
import net.jevring.frequencies.v2.util.ValueFormatter;
import net.jevring.scoundrel.Scoundrel;
import net.jevring.scoundrel.ui.JScoundrelSequencer;

public class ScoundrelUI
extends JPanel {
    private final JMiniWaveformDisplay miniWaveformDisplay = new JMiniWaveformDisplay();
    private final JScoundrelSequencer sequencer;
    private final Configuration configuration;
    private final Scoundrel scoundrel;
    private final Controls controls;
    private volatile JFrame window;

    public ScoundrelUI(Scoundrel scoundrel) {
        this.configuration = scoundrel.getConfiguration();
        this.scoundrel = scoundrel;
        this.controls = scoundrel.getControls();
        this.sequencer = new JScoundrelSequencer(this.controls, scoundrel.getVoices(), scoundrel.getKeyTimings());
        this.createUI();
    }

    public JFrame displayUI(Consumer<Device> restartWithNewDevice) {
        this.window = SwingUtils.showWindowFor("Scoundrel v1.0-SNAPSHOT", this, 1250, 900);
        this.configureMenu(this.window, restartWithNewDevice);
        return this.window;
    }

    private void createUI() {
        SwingUtilities.invokeLater(() -> {
            this.setLayout(new FlowLayout());
            JPanel kick = new JPanel(new GridLayout(4, 2));
            kick.setBorder(BorderFactory.createTitledBorder("Kick"));
            int width = 75;
            kick.add(new JKnob("Level", this.controls.getControl("kick-level"), ValueFormatter.PURE, width));
            kick.add(new JVariableOscillatorKnob(this.controls.getControl("kick-variable-waveform")));
            kick.add(new JKnob("Volume hold", this.controls.getControl("kick-volume-envelope-hold"), ValueFormatter.MILLISECONDS, width));
            kick.add(new JKnob("Volume decay", this.controls.getControl("kick-volume-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            kick.add(new JKnob("Pitch decay", this.controls.getControl("kick-pitch-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            kick.add(new JKnob("Pitch depth", this.controls.getControl("kick-pitch-envelope-modulation-depth"), ValueFormatter.PURE, width));
            kick.add(new JKnob("Noise decay", this.controls.getControl("kick-noise-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            this.add(kick);
            JPanel snare = new JPanel(new GridLayout(4, 2));
            snare.setBorder(BorderFactory.createTitledBorder("Snare"));
            snare.add(new JKnob("Level", this.controls.getControl("snare-level"), ValueFormatter.PURE, width));
            snare.add(new JVariableOscillatorKnob(this.controls.getControl("snare-variable-waveform")));
            snare.add(new JKnob("Volume decay", this.controls.getControl("snare-volume-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            snare.add(new JKnob("Pitch decay", this.controls.getControl("snare-pitch-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            snare.add(new JKnob("Pitch depth", this.controls.getControl("snare-pitch-envelope-modulation-depth"), ValueFormatter.PURE, width));
            snare.add(new JKnob("Noise decay", this.controls.getControl("snare-noise-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            snare.add(new JKnob("Filter Hz", this.controls.getControl("snare-noise-filter-cutoff-frequency"), ValueFormatter.PURE, width));
            this.add(snare);
            JPanel simpleTom = new JPanel(new GridLayout(4, 2));
            simpleTom.setBorder(BorderFactory.createTitledBorder("Simple Tom"));
            simpleTom.add(new JKnob("Level", this.controls.getControl("simple-tom-level"), ValueFormatter.PURE, width));
            simpleTom.add(new JVariableOscillatorKnob(this.controls.getControl("simple-tom-variable-waveform")));
            simpleTom.add(new JKnob("Volume decay", this.controls.getControl("simple-tom-volume-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            simpleTom.add(new JKnob("Pitch decay", this.controls.getControl("simple-tom-pitch-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            simpleTom.add(new JKnob("Pitch depth", this.controls.getControl("simple-tom-pitch-envelope-modulation-depth"), ValueFormatter.PURE, width));
            this.add(simpleTom);
            JPanel laserTom = new JPanel(new GridLayout(4, 3));
            laserTom.setBorder(BorderFactory.createTitledBorder("Laser Tom"));
            laserTom.add(new JKnob("Level", this.controls.getControl("laser-tom-level"), ValueFormatter.PURE, width));
            laserTom.add(new JVariableOscillatorKnob(this.controls.getControl("laser-tom-osc-1-variable-waveform")));
            laserTom.add(new JVariableOscillatorKnob(this.controls.getControl("laser-tom-osc-2-variable-waveform")));
            laserTom.add(new JKnob("Volume decay", this.controls.getControl("laser-tom-volume-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            laserTom.add(new JKnob("Pitch decay", this.controls.getControl("laser-tom-pitch-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            laserTom.add(new JKnob("Pitch depth", this.controls.getControl("laser-tom-pitch-envelope-modulation-depth"), ValueFormatter.PURE, width));
            laserTom.add(new JKnob("Filter Hz", this.controls.getControl("laser-tom-filter-cutoff-frequency"), ValueFormatter.PURE, width));
            laserTom.add(new JKnob("Filter Q", this.controls.getControl("laser-tom-q-resonance-emphasis"), ValueFormatter.PURE, width));
            laserTom.add(new JKnob("Osc1 volume", this.controls.getControl("laser-tom-osc-1-volume"), ValueFormatter.PERCENT, width));
            laserTom.add(new JKnob("Osc2 volume", this.controls.getControl("laser-tom-osc-2-volume"), ValueFormatter.PERCENT, width));
            this.add(laserTom);
            JPanel openHat = new JPanel(new GridLayout(4, 1));
            openHat.setBorder(BorderFactory.createTitledBorder("Open hat"));
            openHat.add(new JKnob("Level", this.controls.getControl("open-hat-level"), ValueFormatter.PURE, width));
            openHat.add(new JKnob("Volume decay", this.controls.getControl("open-hat-volume-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            openHat.add(new JKnob("Filter Hz", this.controls.getControl("open-hat-filter-cutoff-frequency"), ValueFormatter.PURE, width));
            openHat.add(new JKnob("Filter Q", this.controls.getControl("open-hat-q-resonance-emphasis"), ValueFormatter.PURE, width));
            this.add(openHat).setPreferredSize(new Dimension(112, 365));
            JPanel closedHat = new JPanel(new GridLayout(4, 1));
            closedHat.setBorder(BorderFactory.createTitledBorder("Closed hat"));
            closedHat.add(new JKnob("Level", this.controls.getControl("closed-hat-level"), ValueFormatter.PURE, width));
            closedHat.add(new JKnob("Volume decay", this.controls.getControl("closed-hat-volume-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            closedHat.add(new JKnob("Filter Hz", this.controls.getControl("closed-hat-filter-cutoff-frequency"), ValueFormatter.PURE, width));
            closedHat.add(new JKnob("Filter Q", this.controls.getControl("closed-hat-q-resonance-emphasis"), ValueFormatter.PURE, width));
            this.add(closedHat).setPreferredSize(new Dimension(112, 365));
            JPanel clave = new JPanel(new GridLayout(4, 1));
            clave.setBorder(BorderFactory.createTitledBorder("Clave"));
            clave.add(new JKnob("Level", this.controls.getControl("clave-level"), ValueFormatter.PURE, width));
            clave.add(new JKnob("Volume decay", this.controls.getControl("clave-volume-envelope-decay"), ValueFormatter.MILLISECONDS, width));
            this.add(clave).setPreferredSize(new Dimension(113, 365));
            this.add(new JPanel()).setPreferredSize(new Dimension(21, 365));
            this.add(this.sequencer);
        });
    }

    private void configureMenu(final JFrame window, final Consumer<Device> restartWithNewDevice) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMenu fileMenu = ScoundrelUI.this.createFileMenu(window);
                JMenu midiMenu = ScoundrelUI.this.createMidiMenu(window);
                JMenu outputMenu = ScoundrelUI.this.createOutputMenu(restartWithNewDevice);
                JMenuBar mainMenu = new JMenuBar();
                mainMenu.add(fileMenu);
                mainMenu.add(midiMenu);
                mainMenu.add(outputMenu);
                window.setJMenuBar(mainMenu);
            }
        });
    }

    private JMenu createOutputMenu(final Consumer<Device> restartWithNewDevice) {
        JMenu outputMenu = this.styleMenuItem(new JMenu("Outputs"));
        List<Device> supportedSoundDevices = Device.supportedSoundDevices(Scoundrel.AUDIO_FORMAT);
        for (final Device supportedSoundDevice : supportedSoundDevices) {
            outputMenu.add(this.styleMenuItem(new JMenuItem(supportedSoundDevice.describe()))).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    restartWithNewDevice.accept(supportedSoundDevice);
                }
            });
        }
        return outputMenu;
    }

    private JMenu createFileMenu(JFrame window) {
        JMenuItem resetSequencerMenuItem = this.styleMenuItem(new JMenuItem("Reset sequencer", 82));
        resetSequencerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ScoundrelUI.this.configuration.resetSequencer();
            }
        });
        JMenu fileMenu = this.styleMenuItem(new JMenu("File"));
        fileMenu.add(resetSequencerMenuItem);
        return fileMenu;
    }

    private <T extends JMenuItem> T styleMenuItem(T menuItem) {
        menuItem.setFont(new Font(FontSupport.PREFERRED_FONT, 0, 12));
        menuItem.setForeground(Skins.currentSkin().foreground());
        menuItem.setBackground(Skins.currentSkin().background());
        return menuItem;
    }

    private JMenu createMidiMenu(final JFrame window) {
        final MidiManager midiManager = this.scoundrel.getMidiManager();
        final JMenu midiDeviceMenu = this.styleMenuItem(new JMenu("Midi device"));
        midiDeviceMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                midiDeviceMenu.removeAll();
                for (final String compatibleDevice : midiManager.getMidiDevices().compatibleDevices()) {
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(compatibleDevice, midiManager.isCurrentDevice(compatibleDevice));
                    midiDeviceMenu.add(ScoundrelUI.this.styleMenuItem(menuItem)).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (midiManager.isCurrentDevice(compatibleDevice)) {
                                midiManager.disableMidiDevice(compatibleDevice);
                            } else {
                                midiManager.enableMidiDevice(compatibleDevice);
                            }
                        }
                    });
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu midiMappingsMenu = this.styleMenuItem(new JMenu("Midi mappings"));
        midiMappingsMenu.add(this.styleMenuItem(new JMenuItem("Map controls", 67))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MidiMapperGlassPane midiMapperGlassPane = new MidiMapperGlassPane(ScoundrelUI.this, ScoundrelUI.this.scoundrel.getMidiManager().getMidiMappings(), window);
                        window.setGlassPane(midiMapperGlassPane);
                        midiMapperGlassPane.setVisible(true);
                    }
                });
            }
        });
        midiMappingsMenu.add(this.styleMenuItem(new JMenuItem("Save midi config", 83))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                midiManager.writeToDefaultFile();
            }
        });
        midiMappingsMenu.add(this.styleMenuItem(new JMenuItem("Save midi config as", 65))).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(ScoundrelUI.this.configuration.ensureConfigurationDirectoryExists());
                int response = fileChooser.showSaveDialog(window);
                if (response == 0) {
                    midiManager.writeToFile(fileChooser.getSelectedFile());
                }
            }
        });
        final MidiReceiver midiReceiver = midiManager.getReceiver();
        final JMenu midiChannelsMenu = this.styleMenuItem(new JMenu("Midi channels (notes)"));
        midiChannelsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                midiChannelsMenu.removeAll();
                midiChannelsMenu.add(ScoundrelUI.this.styleMenuItem(new JCheckBoxMenuItem("All", midiReceiver.listensOnAllChannels()))).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        midiReceiver.listenOnAllChannels();
                    }
                });
                midiChannelsMenu.add(ScoundrelUI.this.styleMenuItem(new JCheckBoxMenuItem("None", midiReceiver.listensOnNoChannels()))).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        midiReceiver.listenOnNoChannels();
                    }
                });
                int i = 1;
                while (i <= 16) {
                    final int channel = i++;
                    JCheckBoxMenuItem checkBoxForChannel = new JCheckBoxMenuItem("Channel " + channel, midiReceiver.listensToNotesOnChannel(channel));
                    midiChannelsMenu.add(ScoundrelUI.this.styleMenuItem(checkBoxForChannel)).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            boolean currentlyListensOnThisChannel = midiReceiver.listensToNotesOnChannel(channel);
                            midiReceiver.listenToNotesOnChannel(channel, !currentlyListensOnThisChannel);
                        }
                    });
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu midiMenu = this.styleMenuItem(new JMenu("Midi"));
        midiMenu.add(midiDeviceMenu);
        midiMenu.add(midiMappingsMenu);
        midiMenu.add(midiChannelsMenu);
        return midiMenu;
    }

    public void visualizeLoopTime(double percentageOfMax) {
        String labelTest = String.format(Locale.US, "Loop: %03.1f%%", percentageOfMax);
    }

    public void visualizeNewWaveformChunk(double[] samples) {
        this.miniWaveformDisplay.newChunk(samples);
    }

    public SequencerVisualizer getSequenceVisualizer() {
        return this.sequencer;
    }
}

