/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.scoundrel;

import java.io.File;
import java.util.function.Consumer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.jevring.frequencies.v2.configuration.Configuration;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControlListener;
import net.jevring.frequencies.v2.control.curves.Exponential;
import net.jevring.frequencies.v2.control.curves.Linear;
import net.jevring.frequencies.v2.effects.EffectsChain;
import net.jevring.frequencies.v2.engine.MainLoopPullingEngine;
import net.jevring.frequencies.v2.engine.MasterVolume;
import net.jevring.frequencies.v2.engine.Mono;
import net.jevring.frequencies.v2.envelopes.Envelopes;
import net.jevring.frequencies.v2.filters.Filters;
import net.jevring.frequencies.v2.hooks.SequencerVisualizer;
import net.jevring.frequencies.v2.hooks.Visualizer;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.midi.MidiManager;
import net.jevring.frequencies.v2.input.tempo.MainLoopTempoSource;
import net.jevring.frequencies.v2.input.tempo.MidiClockTempoSource;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrix;
import net.jevring.frequencies.v2.output.Device;
import net.jevring.frequencies.v2.ui.Skins;
import net.jevring.scoundrel.ScoundrelUI;
import net.jevring.scoundrel.ScoundrelUIVisualizer;
import net.jevring.scoundrel.input.DrumInput;
import net.jevring.scoundrel.input.DrumSequencer;
import net.jevring.scoundrel.input.DrumVoicePolyphonicSequencerStep;
import net.jevring.scoundrel.input.DrumVoiceStep;
import net.jevring.scoundrel.voices.ClaveVoice;
import net.jevring.scoundrel.voices.ClosedHatVoice;
import net.jevring.scoundrel.voices.DrumVoice;
import net.jevring.scoundrel.voices.KickVoice;
import net.jevring.scoundrel.voices.LaserTomVoice;
import net.jevring.scoundrel.voices.OpenHatVoice;
import net.jevring.scoundrel.voices.SimpleTomVoice;
import net.jevring.scoundrel.voices.SnareVoice;

public class Scoundrel {
    private static final int VOICES = 7;
    private static final float SAMPLE_SIZE_IN_BITS = 16.0f;
    private static final float SAMPLE_RATE = 44100.0f;
    private static final int MONO = 1;
    public static final AudioFormat AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 1, true, true);
    private final KeyTimings keyTimings = new KeyTimings();
    private final Filters filters = new Filters(44100.0);
    private final Controls controls = new Controls();
    private final Envelopes envelopes = new Envelopes();
    private final MidiManager midiManager;
    private final MainLoopPullingEngine engine;
    private final Configuration configuration;
    private final MainLoopTempoSource mainLoopTempoSource;
    private final MidiClockTempoSource midiClockTempoSource;
    private final DrumSequencer drumSequencer;
    private final DrumVoice[] voices;

    public Scoundrel() {
        this.createControls();
        this.midiClockTempoSource = new MidiClockTempoSource();
        this.mainLoopTempoSource = new MainLoopTempoSource(this.controls);
        File dotConfigDirectory = new File(new File(System.getProperty("user.home")), ".config/scoundrel");
        this.midiManager = new MidiManager(this.controls, this.keyTimings, this.midiClockTempoSource, dotConfigDirectory);
        this.midiManager.initializeMidi();
        this.configuration = new Configuration(new ModulationMatrix(this.controls, 7), this.controls, dotConfigDirectory);
        this.voices = new DrumVoice[7];
        this.voices[0] = new KickVoice(this.controls, 44100.0, this.filters);
        this.voices[1] = new SnareVoice(this.controls, 44100.0, this.filters);
        this.voices[2] = new SimpleTomVoice(this.controls, 44100.0);
        this.voices[3] = new LaserTomVoice(this.controls, 44100.0, this.filters);
        this.voices[4] = new OpenHatVoice(this.controls, 44100.0, this.filters);
        this.voices[5] = new ClosedHatVoice(this.controls, 44100.0, this.filters);
        this.voices[6] = new ClaveVoice(this.controls, 44100.0);
        this.controls.createBooleanControl("sequencer-active", false);
        this.controls.createBooleanControl("kick-sequencer-mute", false);
        this.controls.createBooleanControl("snare-sequencer-mute", false);
        this.controls.createBooleanControl("simple-tom-sequencer-mute", false);
        this.controls.createBooleanControl("laser-tom-sequencer-mute", false);
        this.controls.createBooleanControl("open-hat-sequencer-mute", false);
        this.controls.createBooleanControl("closed-hat-sequencer-mute", false);
        this.controls.createBooleanControl("clave-sequencer-mute", false);
        DrumVoicePolyphonicSequencerStep[] sequence = new DrumVoicePolyphonicSequencerStep[16];
        for (int sequenceStep = 0; sequenceStep < sequence.length; ++sequenceStep) {
            DrumVoiceStep[] voicesForStep = new DrumVoiceStep[this.voices.length];
            for (DrumVoice drumVoice : this.voices) {
                voicesForStep[drumVoice.getVoiceIndex()] = new DrumVoiceStep(this.controls.createBooleanControl(drumVoice.getControlPrefix() + "-sequencer-enabled-" + sequenceStep, false), this.controls.getBooleanControl(drumVoice.getControlPrefix() + "-sequencer-mute"), drumVoice.getInstructionNote());
            }
            sequence[sequenceStep] = new DrumVoicePolyphonicSequencerStep(voicesForStep);
        }
        this.drumSequencer = new DrumSequencer(sequence, this.keyTimings, this.controls, this.voices.length);
        DrumInput instructionInput = new DrumInput(this.keyTimings, this.voices);
        this.engine = new MainLoopPullingEngine(new Mono(), instructionInput, EffectsChain.empty(), new MasterVolume(this.controls), 44100.0f, this.voices);
        this.controls.getBooleanControl("receive-midi-clock-active").addListener(new DiscreteControlListener<Boolean>(){

            @Override
            public void valueChanged(Boolean value, Object source) {
                Scoundrel.this.selectTempoSource(value);
            }
        });
    }

    public void startEngine(Device device, SequencerVisualizer sequencerVisualizer, Visualizer visualizer) throws LineUnavailableException {
        this.engine.start(device.open(), visualizer);
        this.drumSequencer.setSequencerVisualizer(sequencerVisualizer);
        this.mainLoopTempoSource.start();
    }

    public void stopEngine() {
        this.mainLoopTempoSource.stop();
        this.engine.stop();
    }

    private void createControls() {
        this.controls.createControl("tempo", 10.0, 750.0, 138.0, new Linear(), true);
        this.controls.createBooleanControl("receive-midi-clock-active", false);
        this.controls.createControl("rate", 2.0, 24.0, 6.0, new Linear(), true);
        this.controls.createControl("pitch-bend", -1.0, 1.0, 0.0, new Linear());
        this.controls.createBooleanControl("legato", false);
        this.controls.createControl("glide-length", 0.0, 1.0, 0.0, new Exponential());
        this.controls.createControl("overdrive-volume", 0.0, 10.0, 0.8, new Exponential());
        this.controls.createControl("balance", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("clave-level", 0.0, 10.0, 0.8, new Exponential());
        this.controls.createControl("clave-volume-envelope-decay", 0.0, 300.0, 200.0, new Exponential());
        this.controls.createControl("open-hat-level", 0.0, 10.0, 0.8, new Exponential());
        this.controls.createControl("open-hat-volume-envelope-decay", 0.0, 2000.0, 1000.0, new Exponential());
        this.controls.createControl("open-hat-filter-cutoff-frequency", 20.0, 20000.0, 4000.0, new Exponential());
        this.controls.createControl("open-hat-q-resonance-emphasis", 0.0, 1.0, 0.25, new Exponential());
        this.controls.createDiscreteControl("open-hat-filter", this.filters.all(), "HighPassJuceIIRFilter");
        this.controls.createControl("closed-hat-level", 0.0, 10.0, 0.8, new Exponential());
        this.controls.createControl("closed-hat-volume-envelope-decay", 0.0, 2000.0, 200.0, new Exponential());
        this.controls.createControl("closed-hat-filter-cutoff-frequency", 20.0, 20000.0, 2000.0, new Exponential());
        this.controls.createControl("closed-hat-q-resonance-emphasis", 0.0, 1.0, 0.25, new Exponential());
        this.controls.createDiscreteControl("closed-hat-filter", this.filters.all(), "HighPassJuceIIRFilter");
        this.controls.createControl("laser-tom-volume-envelope-decay", 0.0, 600.0, 400.0, new Exponential());
        this.controls.createControl("laser-tom-pitch-envelope-decay", 0.0, 600.0, 200.0, new Exponential());
        this.controls.createControl("laser-tom-level", 0.0, 10.0, 0.8, new Exponential());
        this.controls.createControl("laser-tom-osc-1-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("laser-tom-osc-2-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("laser-tom-pitch-envelope-modulation-depth", 0.0, 0.5, 0.25, new Linear());
        this.controls.createControl("laser-tom-filter-envelope-depth", -1.0, 1.0, 0.6, new Linear());
        this.controls.createControl("laser-tom-filter-cutoff-frequency", 20.0, 20000.0, 4000.0, new Exponential());
        this.controls.createControl("laser-tom-q-resonance-emphasis", 0.0, 1.0, 0.25, new Exponential());
        this.controls.createDiscreteControl("laser-tom-filter", this.filters.all(), "DiodeLadderFilter");
        this.controls.createControl("laser-tom-osc-1-volume", 0.0, 1.0, 0.5, new Linear());
        this.controls.createControl("laser-tom-osc-2-volume", 0.0, 1.0, 0.3, new Linear());
        this.controls.createControl("simple-tom-volume-envelope-decay", 0.0, 600.0, 400.0, new Exponential());
        this.controls.createControl("simple-tom-pitch-envelope-decay", 0.0, 40.0, 20.0, new Exponential());
        this.controls.createControl("simple-tom-level", 0.0, 10.0, 0.8, new Exponential());
        this.controls.createControl("simple-tom-octave-offset", -4.0, 4.0, 0.0, new Linear(), true);
        this.controls.createControl("simple-tom-detune-semi-tones", -12.0, 12.0, 0.0, new Linear());
        this.controls.createControl("simple-tom-phase-shift", -0.5, 0.5, 0.0, new Linear());
        this.controls.createControl("simple-tom-wave-shape", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("simple-tom-quantization-steps", 1.0, 16.0, 16.0, new Linear());
        this.controls.createControl("simple-tom-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("simple-tom-unison-detune-semi-tones", 0.0, 2.0, 1.0, new Exponential());
        this.controls.createControl("simple-tom-unison-voices", 1.0, 16.0, 1.0, new Exponential(), true);
        this.controls.createControl("simple-tom-pitch-envelope-modulation-depth", 0.0, 0.5, 0.25, new Linear());
        this.controls.createControl("snare-volume-envelope-decay", 0.0, 500.0, 244.0, new Exponential());
        this.controls.createControl("snare-noise-envelope-decay", 0.0, 600.0, 234.0, new Exponential());
        this.controls.createControl("snare-pitch-envelope-decay", 0.0, 40.0, 20.0, new Exponential());
        this.controls.createControl("snare-level", 0.0, 10.0, 0.8, new Exponential());
        this.controls.createControl("snare-octave-offset", -4.0, 4.0, 0.0, new Linear(), true);
        this.controls.createControl("snare-detune-semi-tones", -12.0, 12.0, 0.0, new Linear());
        this.controls.createControl("snare-phase-shift", -0.5, 0.5, 0.0, new Linear());
        this.controls.createControl("snare-wave-shape", -1.0, 1.0, 0.0, new Linear());
        this.controls.createControl("snare-quantization-steps", 1.0, 16.0, 16.0, new Linear());
        this.controls.createControl("snare-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("snare-unison-detune-semi-tones", 0.0, 2.0, 1.0, new Exponential());
        this.controls.createControl("snare-unison-voices", 1.0, 16.0, 1.0, new Exponential(), true);
        this.controls.createControl("snare-pitch-envelope-modulation-depth", 0.0, 0.5, 0.25, new Linear());
        this.controls.createControl("snare-noise-filter-cutoff-frequency", 20.0, 20000.0, 13000.0, new Exponential());
        this.controls.createControl("snare-noise-q-resonance-emphasis", 0.0, 1.0, 0.0, new Exponential());
        this.controls.createDiscreteControl("snare-noise-filter", this.filters.all(), "DiodeLadderFilter");
        this.controls.createControl("snare-waveform-volume", 0.0, 1.0, 0.5, new Linear());
        this.controls.createControl("snare-noise-volume", 0.0, 1.0, 0.65, new Linear());
        this.controls.createControl("kick-level", 0.0, 10.0, 0.8, new Exponential());
        this.controls.createControl("kick-volume-envelope-hold", 0.0, 1000.0, 20.0, new Exponential());
        this.controls.createControl("kick-volume-envelope-decay", 0.0, 1000.0, 500.0, new Exponential());
        this.controls.createControl("kick-pitch-envelope-decay", 0.0, 1000.0, 200.0, new Exponential());
        this.controls.createControl("kick-noise-envelope-decay", 0.0, 30.0, 20.0, new Exponential());
        this.controls.createControl("kick-pitch-envelope-modulation-depth", 0.0, 0.75, 0.37, new Linear());
        this.controls.createControl("kick-variable-waveform", 0.0, 3.0, 2.0, new Linear());
        this.controls.createControl("kick-noise-filter-envelope-depth", -1.0, 1.0, 0.3, new Linear());
        this.controls.createControl("kick-noise-filter-cutoff-frequency", 20.0, 20000.0, 20.0, new Exponential());
        this.controls.createControl("kick-noise-q-resonance-emphasis", 0.0, 1.0, 0.1, new Exponential());
        this.controls.createDiscreteControl("kick-noise-filter", this.filters.all(), "DiodeLadderFilter");
        this.controls.createControl("kick-waveform-volume", 0.0, 1.0, 0.5, new Linear());
        this.controls.createControl("kick-noise-volume", 0.0, 1.0, 0.5, new Linear());
        this.controls.createBooleanControl("velocity-sensitive-keys", false);
        this.controls.createBooleanControl("clip", true);
    }

    public float getSampleRate() {
        return 44100.0f;
    }

    public Controls getControls() {
        return this.controls;
    }

    public Envelopes getEnvelopes() {
        return this.envelopes;
    }

    public KeyTimings getKeyTimings() {
        return this.keyTimings;
    }

    public MidiManager getMidiManager() {
        return this.midiManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public DrumVoice[] getVoices() {
        return this.voices;
    }

    private void selectTempoSource(boolean midiSyncOn) {
        if (midiSyncOn) {
            this.midiClockTempoSource.addSequencer(this.drumSequencer);
            this.mainLoopTempoSource.removeSequencer(this.drumSequencer);
        } else {
            this.mainLoopTempoSource.addSequencer(this.drumSequencer);
            this.midiClockTempoSource.removeSequencer(this.drumSequencer);
        }
    }

    public static void main(String[] args) throws LineUnavailableException {
        final Scoundrel scoundrel = new Scoundrel();
        String headless = System.getProperty("headless");
        if (headless != null && !"false".equalsIgnoreCase(headless)) {
            scoundrel.startEngine(Device.defaultDevice(AUDIO_FORMAT), SequencerVisualizer.noop(), Visualizer.noop());
        } else {
            final ScoundrelUI ui = new ScoundrelUI(scoundrel);
            scoundrel.startEngine(Device.defaultDevice(AUDIO_FORMAT), ui.getSequenceVisualizer(), new ScoundrelUIVisualizer(ui));
            final JFrame window = ui.displayUI(new Consumer<Device>(){

                @Override
                public void accept(Device device) {
                    try {
                        scoundrel.stopEngine();
                        scoundrel.startEngine(device, ui.getSequenceVisualizer(), new ScoundrelUIVisualizer(ui));
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Skins.setSkin(Skins.defaultSkin(), window);
                }
            });
        }
    }
}

