/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms.open303;

import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.waveforms.open303.InterpolatedWaveform;

public class Open303SawtoothWaveform
extends InterpolatedWaveform {
    public Open303SawtoothWaveform() {
        int n;
        int N = 2048;
        double k = 0.5;
        int N1 = (int)Clamp.clamp(Math.round(k * (double)(N - 1)), 1.0, (double)(N - 1));
        int N2 = N - N1;
        double s1 = 1.0 / (double)(N1 - 1);
        double s2 = 1.0 / (double)N2;
        for (n = 0; n < N1; ++n) {
            this.prototypeTable[n] = s1 * (double)n;
        }
        for (n = N1; n < N; ++n) {
            this.prototypeTable[n] = -1.0 + s2 * (double)(n - N1);
        }
    }

    public String toString() {
        return "Open303Sawtooth";
    }
}

