/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms.open303;

import net.jevring.frequencies.v2.waveforms.WaveShaper;
import net.jevring.frequencies.v2.waveforms.Waveform;

abstract class InterpolatedWaveform
implements Waveform {
    private final WaveShaper waveShaper = new WaveShaper();
    protected static final int tableLength = 2048;
    protected final double[] prototypeTable = new double[2048];

    InterpolatedWaveform() {
    }

    @Override
    public double valueAt(double cycleProgress, double shape, boolean oddCycle, int quantizationSteps, double waveformInterpolation) {
        return this.waveShaper.shapeSample(this.baseValueAt(cycleProgress), shape);
    }

    private double baseValueAt(double cycleProgress) {
        double indexAndRemainder = 2048.0 * cycleProgress;
        int index = (int)indexAndRemainder;
        if (index == 2048) {
            return this.prototypeTable[this.prototypeTable.length - 1];
        }
        if (index == 0) {
            return this.prototypeTable[0];
        }
        double remainder = indexAndRemainder - (double)index;
        return remainder * this.prototypeTable[index - 1] + (1.0 - remainder) * this.prototypeTable[index];
    }
}

