/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms;

import java.util.Locale;
import net.jevring.frequencies.v2.math.Interpolation;
import net.jevring.frequencies.v2.waveforms.SawtoothWaveform;
import net.jevring.frequencies.v2.waveforms.WaveShaper;
import net.jevring.frequencies.v2.waveforms.Waveform;

public class TriangleWaveform
implements Waveform {
    private final SawtoothWaveform saw = new SawtoothWaveform(true);
    private final WaveShaper waveShaper = new WaveShaper();

    @Override
    public double valueAt(double cycleProgress, double shape, boolean oddCycle, int quantizationSteps, double waveformInterpolation) {
        double triangle = this.baseValueAt(cycleProgress);
        if (shape <= -0.1) {
            return this.korgPrologueishWaveShape(shape, triangle);
        }
        if (shape > 0.1) {
            return this.waveShaper.shapeSample(triangle, shape);
        }
        return triangle;
    }

    private double korgPrologueishWaveShape(double shape, double triangle) {
        if (triangle > (shape = Interpolation.linear(-0.1, -1.0, shape, 1.0, 0.25))) {
            double diff = triangle - shape;
            return shape - diff * (1.0 + shape * 2.0);
        }
        if (triangle < -shape) {
            double diff = triangle + shape;
            return -shape - diff * (1.0 + shape * 2.0);
        }
        return triangle;
    }

    private double baseValueAt(double cycleProgress) {
        return 2.0 * Math.abs(this.saw.sawUpFromZero((cycleProgress + 0.25) % 1.0)) - 1.0;
    }

    public String toString() {
        return "Triangle";
    }

    public static void main(String[] args) {
        TriangleWaveform w = new TriangleWaveform();
        for (int i = 1; i <= 10; ++i) {
            double shape = (double)(-i) / 10.0;
            for (double d = 0.0; d <= 1.0; d += 0.01) {
                System.out.printf(Locale.US, "%.3f%n", w.valueAt(d, shape, i % 2 != 0, 0, 0.0));
            }
        }
    }
}

