/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.waveforms;

import java.util.Locale;
import net.jevring.frequencies.v2.waveforms.WaveShaper;
import net.jevring.frequencies.v2.waveforms.Waveform;

public class SawtoothWaveform
implements Waveform {
    private final WaveShaper waveShaper = new WaveShaper();
    private final boolean up;

    public SawtoothWaveform(boolean up) {
        this.up = up;
    }

    @Override
    public double valueAt(double cycleProgress, double shape, boolean oddCycle, int quantizationSteps, double waveformInterpolation) {
        return this.valueAtUp(cycleProgress, shape, oddCycle) * (double)(this.up ? 1 : -1);
    }

    private double valueAtUp(double cycleProgress, double shape, boolean oddCycle) {
        if (shape > 0.1) {
            return this.waveShaper.shapeSample(this.sawUpFromZero(cycleProgress), shape);
        }
        if (shape < -0.1) {
            return this.korgPrologueWaveShape(cycleProgress, Math.abs(shape), oddCycle);
        }
        return this.sawUpFromZero(cycleProgress);
    }

    private double korgPrologueWaveShape(double cycleProgress, double shape, boolean oddCycle) {
        if (oddCycle) {
            return this.sawUpFromZero(cycleProgress);
        }
        double shapeSizeAroundCenter = shape / 2.0;
        if (cycleProgress < 0.5 + shapeSizeAroundCenter && cycleProgress > 0.5 - shapeSizeAroundCenter) {
            return this.sawDownFromZero(cycleProgress);
        }
        return this.sawUpFromZero(cycleProgress);
    }

    double sawUpFromZero(double cycleProgress) {
        return 2.0 * (cycleProgress - Math.floor(cycleProgress + 0.5));
    }

    private double sawUpFromMinusOne(double cycleProgress) {
        return -1.0 + cycleProgress * 2.0;
    }

    private double sawDownFromZero(double cycleProgress) {
        return -1.0 * this.sawUpFromZero(cycleProgress);
    }

    public String toString() {
        return "Sawtooth" + (this.up ? "Up" : "Down");
    }

    public static void main(String[] args) {
        SawtoothWaveform w = new SawtoothWaveform(true);
        for (int i = 1; i < 6; ++i) {
            for (double d = 0.0; d <= 1.0; d += 0.01) {
                System.out.printf(Locale.US, "%.3f%n", w.valueAt(d, 0.5, i % 2 != 0, 0, 0.0));
            }
        }
    }
}

