/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.jevring.frequencies.v2.ui.FontSupport;
import net.jevring.frequencies.v2.ui.JSkinnable;
import net.jevring.frequencies.v2.ui.Skin;

public class Skins {
    private static final Color windows10LightThemeTaskBar = new Color(219, 218, 235);
    private static final Color k9sSelectedPod = new Color(135, 255, 175);
    private static final Color winampCenterBlueGrey = new Color(55, 55, 87);
    private static final Color winampEdgeBlueGrey = new Color(22, 22, 34);
    private static final Color winampButtonGrey = new Color(189, 206, 214);
    private static final Color winampGold = new Color(236, 206, 122);
    private static final Color beige = new Color(204, 201, 179);
    private static final Color intellijIdeaLight = new Color(242, 242, 242);
    public static final Skin DARK = new Skin("Dark", Color.gray, Color.WHITE, Color.WHITE, Color.darkGray, Color.white, Color.green, Color.yellow, true);
    public static final Skin DARK_OPAQUE = new Skin("Dark (frikkin' laser beams!)", Color.gray, Color.WHITE, Color.WHITE, Color.darkGray, Color.white, Color.green, Color.yellow, false);
    public static final Skin LIGHT = new Skin("Light", Color.white, Color.BLACK, Color.BLACK, Color.darkGray, Color.white, Color.green, Color.yellow, true);
    public static final Skin BLUE_RED = new Skin("Light", Color.white, Color.BLACK, Color.BLACK, Color.darkGray, Color.white, Color.blue, Color.red, false);
    private static volatile Skin currentSkin = Skins.defaultSkin();

    public static Skin defaultSkin() {
        return LIGHT;
    }

    public static Skin currentSkin() {
        return currentSkin;
    }

    public static List<Skin> skins() {
        return List.of(DARK, DARK_OPAQUE, LIGHT);
    }

    public static void setSkin(Skin skin, Component c) {
        try {
            MetalLookAndFeel.setCurrentTheme(new SkinnedMetalTheme(skin));
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            SwingUtilities.updateComponentTreeUI(c);
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        Skins.setSkin0(skin, c);
    }

    private static void setSkin0(final Skin skin, Component c) {
        Component jPanel;
        currentSkin = skin;
        Component component = c;
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (!(c instanceof JMenuBar)) {
                jComponent.setOpaque(skin.opaque());
            }
        }
        if ((component = c) instanceof JSkinnable) {
            JSkinnable jSkinnable = (JSkinnable)((Object)component);
            jSkinnable.setSkin(skin);
        } else {
            c.setBackground(skin.background());
            c.setForeground(skin.foreground());
            Component component2 = c;
            if (component2 instanceof JPanel) {
                jPanel = (JPanel)component2;
                border = ((JComponent)jPanel).getBorder();
                var7_6 = border;
                if (var7_6 instanceof TitledBorder) {
                    TitledBorder titledBorder = (TitledBorder)var7_6;
                    titledBorder.setTitleColor(skin.text());
                    Border border = titledBorder.getBorder();
                    if (border instanceof LineBorder) {
                        LineBorder lineBorder = (LineBorder)border;
                        titledBorder.setBorder(new BorderUIResource.LineBorderUIResource(skin.foreground(), lineBorder.getThickness()));
                    }
                }
            } else {
                border = c;
                if (border instanceof JComboBox) {
                    JComboBox comboBox = (JComboBox)border;
                    Component editorComponent = comboBox.getEditor().getEditorComponent();
                    var7_6 = editorComponent;
                    if (var7_6 instanceof JComponent) {
                        JComponent jEditorComponent = (JComponent)var7_6;
                        jEditorComponent.setOpaque(skin.opaque());
                    }
                    final ListCellRenderer originalRenderer = comboBox.getRenderer();
                    comboBox.setRenderer(new BasicComboBoxRenderer.UIResource(){

                        @Override
                        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            Component listCellRendererComponent = originalRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                            Component component = listCellRendererComponent;
                            if (component instanceof JComponent) {
                                JComponent jListCellRendererComponent = (JComponent)component;
                                jListCellRendererComponent.setOpaque(skin.opaque());
                            }
                            return listCellRendererComponent;
                        }
                    });
                }
            }
        }
        jPanel = c;
        if (jPanel instanceof Container) {
            Container container = (Container)jPanel;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component3 = container.getComponent(i);
                Skins.setSkin0(skin, component3);
            }
        }
    }

    private static final class SkinnedMetalTheme
    extends DefaultMetalTheme {
        private final FontUIResource font = new FontUIResource(FontSupport.PREFERRED_FONT, 0, 12);
        private final Skin skin;

        private SkinnedMetalTheme(Skin skin) {
            this.skin = skin;
        }

        @Override
        public ColorUIResource getControlInfo() {
            return new ColorUIResource(this.skin.foreground());
        }

        @Override
        public FontUIResource getControlTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getSystemTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getUserTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getMenuTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.font;
        }

        @Override
        public FontUIResource getSubTextFont() {
            return this.font;
        }
    }
}

