/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.jevring.frequencies.v2.input.midi.MidiMappings;
import net.jevring.frequencies.v2.ui.JControlChangeMappable;

public class MidiMapperGlassPane
extends JComponent {
    private final List<JComponent> components = new ArrayList<JComponent>();
    private final MidiMappings midiMappings;
    private final JFrame window;
    private Component selected;

    public MidiMapperGlassPane(final JComponent container, final MidiMappings midiMappings, JFrame window) {
        this.midiMappings = midiMappings;
        this.window = window;
        this.enumerate(container, this.components);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point pointRelativeToTheUI = SwingUtilities.convertPoint(MidiMapperGlassPane.this, e.getPoint(), container);
                Component deepestComponentAt = SwingUtilities.getDeepestComponentAt(container, (int)pointRelativeToTheUI.getX(), (int)pointRelativeToTheUI.getY());
                Component component = deepestComponentAt;
                if (component instanceof JControlChangeMappable) {
                    JControlChangeMappable jccm = (JControlChangeMappable)((Object)component);
                    if (MidiMapperGlassPane.this.selected == deepestComponentAt) {
                        MidiMapperGlassPane.this.selected = null;
                        midiMappings.stopListeningForNewMidiMapping();
                    } else {
                        MidiMapperGlassPane.this.selected = deepestComponentAt;
                        midiMappings.listenForNewMidiMapping(jccm.getControl());
                    }
                } else {
                    MidiMapperGlassPane.this.selected = null;
                    midiMappings.stopListeningForNewMidiMapping();
                    MidiMapperGlassPane.this.setVisible(false);
                }
                MidiMapperGlassPane.this.repaint();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.midiMappings.stopListeningForNewMidiMapping();
        }
        super.setVisible(visible);
    }

    private void enumerate(JComponent c, List<JComponent> components) {
        if (c instanceof JControlChangeMappable) {
            components.add(c);
        }
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component component = c.getComponent(i);
            Component component2 = component;
            if (!(component2 instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component2;
            this.enumerate(jComponent, components);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        for (JComponent component : this.components) {
            JComponent jComponent = component;
            if (!(jComponent instanceof JControlChangeMappable)) continue;
            JControlChangeMappable jccm = (JControlChangeMappable)((Object)jComponent);
            Point point = SwingUtilities.convertPoint(component, 0, 0, this.window.getRootPane());
            int x = (int)point.getX();
            int y = (int)point.getY();
            g.setColor(new Color(255, 175, 175, 127));
            g.fillRect(x, y, component.getWidth(), component.getHeight());
            if (component != this.selected) continue;
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(3.0f));
            g.setColor(Color.RED);
            g.drawRect(x, y, component.getWidth(), component.getHeight());
        }
    }
}

