/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.ui.Bindings;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;
import net.jevring.frequencies.v2.ui.JKnob;
import net.jevring.frequencies.v2.ui.JVariableOscillatorKnob;
import net.jevring.frequencies.v2.util.ValueFormatter;

public class LFOPanel
extends JPanel {
    public LFOPanel(Controls controls, String prefix) {
        this.setBorder(new TitledBorder(null, prefix.toUpperCase(), 1, 2));
        this.setAlignmentY(0.0f);
        JKnob quantizationSteps = new JKnob("Steps", controls.getControl(prefix + "-quantization-steps"), ValueFormatter.INTEGER_16_OFF);
        JVariableOscillatorKnob waveformKnob = new JVariableOscillatorKnob(controls.getControl(prefix + "-variable-waveform"));
        JKnob frequency = new JKnob("Frequency", controls.getControl(prefix + "-frequency"), ValueFormatter.LOW_FREQUENCY);
        JKnob waveShape = new JKnob("Shape", controls.getControl(prefix + "-wave-shape"));
        JCheckBox keyReset = new JCheckBox("Retrigger");
        Bindings.bind(keyReset, controls.getBooleanControl(prefix + "-key-reset"));
        this.setLayout(new GridBagLayout());
        this.add((Component)frequency, GridBadLayoutUtils.gbc(0, 0, 1, 1, 1.0, 1.0));
        this.add((Component)waveformKnob, GridBadLayoutUtils.gbc(1, 0, 1, 1, 1.0, 1.0));
        this.add((Component)quantizationSteps, GridBadLayoutUtils.gbc(0, 1, 1, 1, 1.0, 1.0));
        this.add((Component)waveShape, GridBadLayoutUtils.gbc(1, 1, 1, 1, 1.0, 1.0));
        this.add((Component)keyReset, GridBadLayoutUtils.gbc(0, 2, 2, 1, 1.0, 1.0));
    }
}

