/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.curves.Linear;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;
import net.jevring.frequencies.v2.ui.JControlChangeMappable;
import net.jevring.frequencies.v2.ui.JSkinnable;
import net.jevring.frequencies.v2.ui.Skin;
import net.jevring.frequencies.v2.ui.Skins;

public class JSmallKnob
extends JPanel
implements JControlChangeMappable,
JSkinnable {
    private static final boolean DOT_INDICATOR = false;
    private static final double SENSITIVITY = 50.0;
    private static final int DIAMETER = 25;
    private volatile int mouseClickedLocation = -1;
    private volatile double valueAtMouseClick = -1.0;
    private volatile Control control = new Control("noop", -1.0, 0.0, 1.0, new Linear(), false);
    private volatile Skin skin = Skins.defaultSkin();

    public JSmallKnob() {
        Dimension size = new Dimension(27, 27);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
        ToolTipManager.sharedInstance().setInitialDelay(150);
        this.updateTooltip();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    JSmallKnob.this.mouseClickedLocation = e.getY();
                    JSmallKnob.this.valueAtMouseClick = JSmallKnob.this.control.getCurrentValue();
                } else {
                    JSmallKnob.this.mouseClickedLocation = -1;
                    JSmallKnob.this.valueAtMouseClick = -1.0;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JSmallKnob.this.mouseClickedLocation != -1) {
                    int distance = JSmallKnob.this.mouseClickedLocation - e.getY();
                    double domainChange = distance > 0 ? Interpolation.linear(0.0, 50.0, distance, 0.0, JSmallKnob.this.control.getMax()) : Interpolation.linear(50.0, 0.0, distance, JSmallKnob.this.control.getMax(), 0.0);
                    double newValue = JSmallKnob.this.valueAtMouseClick + domainChange;
                    double domainValue = Clamp.clamp(newValue, JSmallKnob.this.control.getMin(), JSmallKnob.this.control.getMax());
                    JSmallKnob.this.updateTooltip();
                    JSmallKnob.this.control.set(JSmallKnob.this.control.getMin(), domainValue, JSmallKnob.this.control.getMax(), JSmallKnob.this);
                    JSmallKnob.this.repaint();
                }
            }
        });
    }

    private void updateTooltip() {
        this.setToolTipText(String.format(Locale.US, "%.2f", this.control.getCurrentValue()));
    }

    public void attachControl(Control control) {
        Objects.requireNonNull(control);
        this.control = control;
        this.control.addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                JSmallKnob.this.repaint();
            }
        });
        this.repaint();
    }

    @Override
    public void setSkin(Skin skin) {
        this.skin = skin;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isOpaque()) {
            g.setColor(this.skin.background());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        int width = this.getWidth();
        g.setColor(this.skin.knobBackground());
        int xOffset = (int)Math.round((double)(width - 25) / 2.0);
        boolean yOffset = false;
        g.fillOval(xOffset, 0, 25, 25);
        double degrees = Interpolation.linear(this.control.getMin(), this.control.getMax(), this.control.getCurrentValue(), 0.0, 270.0) + 135.0;
        double radiansPerDegree = Math.PI / 180;
        double theta = degrees * radiansPerDegree;
        double radius = 12.5;
        double endX = (double)xOffset + (radius + radius * Math.cos(theta));
        double endY = (double)yOffset + (radius + radius * Math.sin(theta));
        double centerX = (double)xOffset + radius;
        double centerY = (double)yOffset + radius;
        double lengthX = endX - centerX;
        double lengthY = endY - centerY;
        double segmentStartX = centerX + lengthX * 0.6;
        double segmentStartY = centerY + lengthY * 0.6;
        double segmentEndX = centerX + lengthX * 0.9;
        double segmentEndY = centerY + lengthY * 0.9;
        g.setColor(this.skin.knobForeground());
        g2.setStroke(new BasicStroke(3.0f, 1, 1));
        g.drawLine((int)Math.round(segmentStartX), (int)Math.round(segmentStartY), (int)Math.round(segmentEndX), (int)Math.round(segmentEndY));
    }

    @Override
    public String getControl() {
        return this.control.getKey();
    }
}

