/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;
import net.jevring.frequencies.v2.ui.JKnob;
import net.jevring.frequencies.v2.ui.JVariableOscillatorKnob;
import net.jevring.frequencies.v2.util.ValueFormatter;

public class JOscillatorPanel
extends JPanel {
    public JOscillatorPanel(Controls controls, String oscillatorControlPrefix) {
        JKnob octaveOffsetKnob = new JKnob("Octave", controls.getControl(oscillatorControlPrefix + "-octave-offset"), ValueFormatter.INTEGER);
        JVariableOscillatorKnob waveformKnob = new JVariableOscillatorKnob(controls.getControl(oscillatorControlPrefix + "-variable-waveform"));
        JKnob quantizationSteps = new JKnob("Steps", controls.getControl(oscillatorControlPrefix + "-quantization-steps"), ValueFormatter.INTEGER_16_OFF);
        JKnob detuneKnob = new JKnob("Detune", controls.getControl(oscillatorControlPrefix + "-detune-semi-tones"), ValueFormatter.SEMITONES);
        JKnob waveShapeKnob = new JKnob("Shape", controls.getControl(oscillatorControlPrefix + "-wave-shape"));
        JKnob phaseShiftKnob = new JKnob("Phase", controls.getControl(oscillatorControlPrefix + "-phase-shift"));
        JKnob unisonVoicesKnob = new JKnob("Voices", controls.getControl(oscillatorControlPrefix + "-unison-voices"));
        JLabel unisonLabel = new JLabel("Unison", 0);
        JKnob unisonDetuneKnob = new JKnob("Detune", controls.getControl(oscillatorControlPrefix + "-unison-detune-semi-tones"), ValueFormatter.SEMITONES);
        detuneKnob.setAlignmentX(0.5f);
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, this.titleOf(oscillatorControlPrefix), 1, 2));
        this.add((Component)octaveOffsetKnob, GridBadLayoutUtils.gbc(0, 0, 1, 1, 1.0, 1.0));
        this.add((Component)waveformKnob, GridBadLayoutUtils.gbc(1, 0, 1, 1, 1.0, 1.0));
        this.add((Component)quantizationSteps, GridBadLayoutUtils.gbc(2, 0, 1, 1, 1.0, 1.0));
        this.add((Component)detuneKnob, GridBadLayoutUtils.gbc(0, 2, 1, 1, 1.0, 1.0));
        this.add((Component)waveShapeKnob, GridBadLayoutUtils.gbc(1, 2, 1, 1, 1.0, 1.0));
        this.add((Component)phaseShiftKnob, GridBadLayoutUtils.gbc(2, 2, 1, 1, 1.0, 1.0));
        this.add((Component)unisonVoicesKnob, GridBadLayoutUtils.gbc(0, 3, 1, 1, 1.0, 1.0));
        this.add((Component)unisonLabel, GridBadLayoutUtils.gbc(1, 3, 1, 1, 1.0, 1.0));
        this.add((Component)unisonDetuneKnob, GridBadLayoutUtils.gbc(2, 3, 1, 1, 1.0, 1.0));
    }

    private String titleOf(String oscillatorControlPrefix) {
        if ("primary-oscillator".equals(oscillatorControlPrefix)) {
            return "Primary oscillator";
        }
        return "Secondary oscillator";
    }
}

