/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.ui;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.ui.Bindings;
import net.jevring.frequencies.v2.ui.JKnob;
import net.jevring.frequencies.v2.util.ValueFormatter;

public class JMixerPanel
extends JPanel {
    public JMixerPanel(Controls controls) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder(null, "Mixer", 1, 2));
        this.setAlignmentY(0.0f);
        JKnob noiseOscillatorVolume = new JKnob("Noise", controls.getControl("noise-oscillator-volume"), ValueFormatter.PERCENT, 70);
        JKnob primaryOscillatorVolume = new JKnob("Primary", controls.getControl("primary-oscillator-volume"), ValueFormatter.PERCENT, 70);
        JKnob secondaryOscillatorVolume = new JKnob("Secondary", controls.getControl("secondary-oscillator-volume"), ValueFormatter.PERCENT, 70);
        JCheckBox clip = new JCheckBox("Clip");
        Bindings.bind(clip, controls.getBooleanControl("clip"));
        JKnob overdriveKnob = new JKnob("Overdrive", controls.getControl("overdrive-volume"), ValueFormatter.PURE, 70);
        JKnob balanceKnob = new JKnob("Balance", controls.getControl("balance"), ValueFormatter.PURE, 70);
        noiseOscillatorVolume.setAlignmentX(0.0f);
        primaryOscillatorVolume.setAlignmentX(0.0f);
        secondaryOscillatorVolume.setAlignmentX(0.0f);
        overdriveKnob.setAlignmentX(0.0f);
        clip.setAlignmentX(0.0f);
        balanceKnob.setAlignmentX(0.0f);
        this.add(noiseOscillatorVolume);
        this.add(primaryOscillatorVolume);
        this.add(secondaryOscillatorVolume);
        this.add(overdriveKnob);
        this.add(clip);
        this.add(balanceKnob);
    }
}

