/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WaveFileWriter {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final AudioFormat audioFormat;
    private final boolean record;
    private int filesWritten = 0;

    public WaveFileWriter(AudioFormat audioFormat, boolean record) {
        this.audioFormat = audioFormat;
        this.record = record;
    }

    public void write(byte[] bytes) {
        if (!this.record) {
            return;
        }
        this.byteArrayOutputStream.writeBytes(bytes);
        if (this.byteArrayOutputStream.size() > 1764000) {
            this.dumpSoundDataAndReset();
        }
    }

    public void dumpSoundDataAndReset() {
        if (!this.record) {
            return;
        }
        try {
            byte[] sound = this.byteArrayOutputStream.toByteArray();
            File out = new File("output-" + this.filesWritten++ + ".wav");
            System.out.println("Dumping WAVE data to " + out);
            AudioSystem.write(new AudioInputStream(new ByteArrayInputStream(sound), this.audioFormat, sound.length), AudioFileFormat.Type.WAVE, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.byteArrayOutputStream.reset();
    }
}

