/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modulation.matrix;

import java.util.List;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.curves.Linear;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrixRow;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrixVoice;
import net.jevring.frequencies.v2.modulation.matrix.ModulationSource;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;

public class ModulationMatrix {
    private final ModulationMatrixVoice[] voices;
    private final Controls controls;

    public ModulationMatrix(Controls controls, int numberOfVoices) {
        this.controls = controls;
        this.voices = new ModulationMatrixVoice[numberOfVoices];
        for (int i = 0; i < numberOfVoices; ++i) {
            this.voices[i] = new ModulationMatrixVoice();
        }
    }

    public ModulationMatrixVoice voice(int i) {
        return this.voices[i];
    }

    public Control add(ModulationSource modulationSource, ModulationTarget modulationTarget) {
        String depthControlName = this.controlName(modulationSource, modulationTarget);
        Control modulationDepthControl = this.controls.getControl(depthControlName);
        if (modulationDepthControl == null) {
            modulationDepthControl = this.controls.createControl(depthControlName, -1.0, 1.0, 0.0, new Linear());
        }
        for (ModulationMatrixVoice voice : this.voices) {
            voice.add(modulationSource, modulationTarget, modulationDepthControl, false);
        }
        return modulationDepthControl;
    }

    public void remove(ModulationSource modulationSource, ModulationTarget modulationTarget) {
        for (ModulationMatrixVoice voice : this.voices) {
            voice.remove(modulationSource, modulationTarget);
        }
    }

    private String controlName(ModulationSource modulationSource, ModulationTarget modulationTarget) {
        return this.lowerCaseSnakeCase(modulationSource.name()) + "-to-" + this.lowerCaseSnakeCase(modulationTarget.name()) + "-depth";
    }

    private String lowerCaseSnakeCase(String s) {
        return s.toLowerCase().replaceAll("_", "-");
    }

    public void clear() {
        for (ModulationMatrixVoice voice : this.voices) {
            voice.clear();
        }
    }

    public List<ModulationMatrixRow> getModulationConfig(boolean includeHardwired) {
        return this.voices[0].getModulationConfig(includeHardwired);
    }
}

