/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modulation.matrix;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AdditiveMultiSource;
import net.jevring.frequencies.v2.modular.AttenuverterModule;
import net.jevring.frequencies.v2.modulation.SidedDepth;
import net.jevring.frequencies.v2.modulation.matrix.ModulationSource;

public class Connection {
    private final Set<ModulationSource> hardwiredSources = EnumSet.noneOf(ModulationSource.class);
    private final Map<ModulationSource, AttenuverterModule> connections = new LinkedHashMap<ModulationSource, AttenuverterModule>();
    private final AdditiveMultiSource additiveMultiSource;

    public Connection(AdditiveMultiSource additiveMultiSource) {
        this.additiveMultiSource = additiveMultiSource;
    }

    public void connect(ModulationSource modulationSource, AttenuverterModule input, boolean hardwired) {
        if (this.connections.putIfAbsent(modulationSource, input) != null) {
            System.err.println("Connection to " + modulationSource + " already present. Skipping.");
            return;
        }
        this.additiveMultiSource.connect(input);
        if (hardwired) {
            this.hardwiredSources.add(modulationSource);
        }
    }

    public void disconnect(ModulationSource modulationSource) {
        if (this.hardwiredSources.contains((Object)modulationSource)) {
            System.err.println("Modulation source is hardwired: " + modulationSource);
            return;
        }
        this.additiveMultiSource.disconnect(this.connections.remove((Object)modulationSource));
    }

    public SidedDepth getSidedDepth() {
        double positive = 0.0;
        double negative = 0.0;
        for (Map.Entry<ModulationSource, AttenuverterModule> entry : this.connections.entrySet()) {
            ModulationSource modulationSource = entry.getKey();
            AttenuverterModule attenuverterModule = entry.getValue();
            double depth = attenuverterModule.getDepth().getCurrentValue();
            if (modulationSource.isBipolar()) {
                positive += Math.abs(depth);
                negative -= Math.abs(depth);
                continue;
            }
            if (depth < 0.0) {
                negative += depth;
                continue;
            }
            positive += depth;
        }
        return new SidedDepth(positive, negative);
    }

    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        return this.additiveMultiSource.generateSamples(samplesToGenerate, instruction);
    }

    public void clear() {
        Iterator<Map.Entry<ModulationSource, AttenuverterModule>> ic = this.connections.entrySet().iterator();
        while (ic.hasNext()) {
            Map.Entry<ModulationSource, AttenuverterModule> next = ic.next();
            if (this.hardwiredSources.contains((Object)next.getKey())) continue;
            ic.remove();
            this.additiveMultiSource.disconnect(next.getValue());
        }
    }

    public Map<ModulationSource, AttenuverterModule> getConnections(boolean includeHardwired) {
        if (includeHardwired) {
            return Collections.unmodifiableMap(this.connections);
        }
        return this.connections.entrySet().stream().filter(entry -> !this.hardwiredSources.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

