/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.AdditiveMultiSource;
import net.jevring.frequencies.v2.modular.Source;

public class TripleControllerMixer
implements Source {
    private final Source noise;
    private final Source osc1;
    private final Source osc2;
    private final Control noiseVolume;
    private final Control osc1Volume;
    private final Control osc2Volume;
    private final AdditiveMultiSource noiseModulation = new AdditiveMultiSource();
    private final AdditiveMultiSource osc1Modulation = new AdditiveMultiSource();
    private final AdditiveMultiSource osc2Modulation = new AdditiveMultiSource();
    private volatile double[] samples;

    public TripleControllerMixer(Source noise, Source osc1, Source osc2, Control noiseVolume, Control osc1Volume, Control osc2Volume) {
        this.noise = noise;
        this.osc1 = osc1;
        this.osc2 = osc2;
        this.noiseVolume = noiseVolume;
        this.osc1Volume = osc1Volume;
        this.osc2Volume = osc2Volume;
    }

    public AdditiveMultiSource getNoiseModulation() {
        return this.noiseModulation;
    }

    public AdditiveMultiSource getOsc1Modulation() {
        return this.osc1Modulation;
    }

    public AdditiveMultiSource getOsc2Modulation() {
        return this.osc2Modulation;
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            double[] output = new double[samplesToGenerate];
            double[] noiseSamples = this.noise.generateSamples(samplesToGenerate, instruction);
            double[] osc1Samples = this.osc1.generateSamples(samplesToGenerate, instruction);
            double[] osc2Samples = this.osc2.generateSamples(samplesToGenerate, instruction);
            double[] osc1VolumeModulation = this.osc1Modulation.generateSamples(samplesToGenerate, instruction);
            double[] osc2VolumeModulation = this.osc2Modulation.generateSamples(samplesToGenerate, instruction);
            double[] noiseVolumeModulation = this.noiseModulation.generateSamples(samplesToGenerate, instruction);
            for (int i = 0; i < samplesToGenerate; ++i) {
                double osc1Sample = osc1Samples[i];
                double osc2Sample = osc2Samples[i];
                double noiseSample = noiseSamples[i];
                output[i] = osc1Sample * (this.osc1Volume.getCurrentValue() + osc1VolumeModulation[i]) + osc2Sample * (this.osc2Volume.getCurrentValue() + osc2VolumeModulation[i]) + noiseSample * (this.noiseVolume.getCurrentValue() + noiseVolumeModulation[i]);
            }
            this.samples = output;
        }
        return this.samples;
    }

    @Override
    public void next() {
        this.osc1.next();
        this.osc2.next();
        this.noise.next();
        this.osc1Modulation.next();
        this.osc2Modulation.next();
        this.noiseModulation.next();
        this.samples = null;
    }
}

