/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.Source;

public class ScalingModule
implements Source {
    private final BooleanControl enabled;
    private volatile Source input = Source.DISCONNECTED;
    private volatile Source scaleInput = Source.DISCONNECTED;
    private volatile double[] samples;

    public ScalingModule(BooleanControl enabled) {
        this.enabled = enabled;
    }

    public void setInput(Source input) {
        this.input = input;
    }

    public void setScaleInput(Source scaleInput) {
        this.scaleInput = scaleInput;
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            double[] samples = this.input.generateSamples(samplesToGenerate, instruction);
            if (this.enabled.get()) {
                double[] scaledSamples = this.scaleInput.generateSamples(samplesToGenerate, instruction);
                double[] output = new double[samplesToGenerate];
                for (int i = 0; i < samplesToGenerate; ++i) {
                    output[i] = samples[i] * scaledSamples[i];
                }
                this.samples = output;
            } else {
                this.samples = samples;
            }
        }
        return this.samples;
    }

    @Override
    public void next() {
        this.input.next();
        this.scaleInput.next();
        this.samples = null;
    }
}

