/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import java.util.Arrays;
import java.util.Objects;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.Source;

public class AttenuverterModule
implements Source {
    private final Control depth;
    private final Source input;
    private volatile double[] samples;

    public AttenuverterModule(Control depth, Source input) {
        this.depth = Objects.requireNonNull(depth);
        this.input = Objects.requireNonNull(input);
    }

    public Control getDepth() {
        return this.depth;
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            double[] samples = this.input.generateSamples(samplesToGenerate, instruction);
            double depth = this.depth.getCurrentValue();
            this.samples = Arrays.stream(samples).map(s -> s * depth).toArray();
        }
        return this.samples;
    }

    @Override
    public void next() {
        this.input.next();
        this.samples = null;
    }
}

